/*
 * Decompiled with CFR 0.152.
 */
package io.github.green4j.jelly;

import io.github.green4j.jelly.JsonBufferedWriter;
import java.io.IOException;

public final class AppendableWriter<T extends Appendable>
implements JsonBufferedWriter {
    private final JsonBufferedWriter.Frame frame = new JsonBufferedWriter.Frame(){

        @Override
        public void setCharAt(int index, char c) {
            ((AppendableWriter)AppendableWriter.this).frameArray[index] = c;
        }

        @Override
        public char charAt(int index) {
            return AppendableWriter.this.frameArray[index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public int length() {
            return Math.abs(AppendableWriter.this.frameSize);
        }

        @Override
        public String toString() {
            return new String(AppendableWriter.this.frameArray, 0, this.length());
        }
    };
    private char[] frameArray = new char[32];
    private int frameSize;
    private T output;

    public AppendableWriter() {
    }

    public AppendableWriter(T output) {
        this.set(output);
    }

    public void set(T output) {
        this.output = output;
    }

    public T output() {
        return this.output;
    }

    @Override
    public JsonBufferedWriter.Frame append(int size) {
        assert (size > 0);
        try {
            this.tryPushFrame();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.makeSureFrameSize(size);
        this.frameSize = -size;
        return this.frame;
    }

    @Override
    public void append(char c) {
        assert (this.output != null);
        try {
            this.tryPushFrame();
            this.output.append(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void append(CharSequence data) {
        assert (this.output != null);
        try {
            this.tryPushFrame();
            this.output.append(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void append(CharSequence data, int start, int len) {
        assert (this.output != null);
        try {
            this.tryPushFrame();
            this.output.append(data, start, start + len);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flush() {
        if (this.output == null) {
            return;
        }
        try {
            this.tryPushFrame();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void tryPushFrame() throws IOException {
        if (this.frameSize < 0) {
            this.output.append(this.frame);
            this.frameSize = -this.frameSize;
        }
    }

    private void makeSureFrameSize(int roomSize) {
        int delta = this.frameArray.length - roomSize;
        if (delta < 0) {
            int newSize = Math.max(roomSize, this.frameArray.length) << 1;
            char[] newArray = new char[newSize];
            this.frameArray = newArray;
        }
    }

    public String toString() {
        if (this.output == null) {
            return "null";
        }
        return this.output.toString();
    }
}

