/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.impl.AbstractElement;
import io.github.dmlloyd.classfile.impl.DirectCodeBuilder;
import io.github.dmlloyd.classfile.instruction.LineNumber;

public final class LineNumberImpl
extends AbstractElement
implements LineNumber {
    private static final int INTERN_LIMIT = 1000;
    private static final LineNumber[] internCache = new LineNumber[1000];
    private final int line;

    private LineNumberImpl(int line) {
        this.line = line;
    }

    public static LineNumber of(int line) {
        return line < 1000 ? internCache[line] : new LineNumberImpl(line);
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public void writeTo(DirectCodeBuilder writer) {
        writer.setLineNumber(this.line);
    }

    public String toString() {
        return String.format("LineNumber[line=%d]", this.line);
    }

    static {
        for (int i = 0; i < 1000; ++i) {
            LineNumberImpl.internCache[i] = new LineNumberImpl(i);
        }
    }
}

