/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielliu1123.httpexchange.shaded;

import io.github.danielliu1123.httpexchange.shaded.ShadedHttpServiceMethod;
import jakarta.annotation.Nullable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.reactor.MonoKt;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.util.Assert;
import org.springframework.util.StringValueResolver;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.service.annotation.HttpExchange;
import org.springframework.web.service.invoker.AbstractReactorHttpExchangeAdapter;
import org.springframework.web.service.invoker.CookieValueArgumentResolver;
import org.springframework.web.service.invoker.HttpClientAdapter;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpMethodArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import org.springframework.web.service.invoker.PathVariableArgumentResolver;
import org.springframework.web.service.invoker.RequestAttributeArgumentResolver;
import org.springframework.web.service.invoker.RequestBodyArgumentResolver;
import org.springframework.web.service.invoker.RequestHeaderArgumentResolver;
import org.springframework.web.service.invoker.RequestParamArgumentResolver;
import org.springframework.web.service.invoker.RequestPartArgumentResolver;
import org.springframework.web.service.invoker.UriBuilderFactoryArgumentResolver;
import org.springframework.web.service.invoker.UrlArgumentResolver;
import reactor.core.publisher.Mono;

public final class ShadedHttpServiceProxyFactory {
    private final HttpExchangeAdapter exchangeAdapter;
    private final List<HttpServiceArgumentResolver> argumentResolvers;
    @Nullable
    private final StringValueResolver embeddedValueResolver;

    private ShadedHttpServiceProxyFactory(HttpExchangeAdapter exchangeAdapter, List<HttpServiceArgumentResolver> argumentResolvers, @Nullable StringValueResolver embeddedValueResolver) {
        this.exchangeAdapter = exchangeAdapter;
        this.argumentResolvers = argumentResolvers;
        this.embeddedValueResolver = embeddedValueResolver;
    }

    public <S> S createClient(Class<S> serviceType) {
        List<ShadedHttpServiceMethod> httpServiceMethods = MethodIntrospector.selectMethods(serviceType, this::isExchangeMethod).stream().map(method -> this.createHttpServiceMethod(serviceType, (Method)method)).toList();
        return (S)ProxyFactory.getProxy(serviceType, (Interceptor)new HttpServiceMethodInterceptor(httpServiceMethods));
    }

    private boolean isExchangeMethod(Method method) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, HttpExchange.class) || AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, RequestMapping.class);
    }

    private <S> ShadedHttpServiceMethod createHttpServiceMethod(Class<S> serviceType, Method method) {
        Assert.notNull(this.argumentResolvers, (String)"No argument resolvers: afterPropertiesSet was not called");
        return new ShadedHttpServiceMethod(method, serviceType, this.argumentResolvers, this.exchangeAdapter, this.embeddedValueResolver);
    }

    public static Builder builderFor(HttpExchangeAdapter exchangeAdapter) {
        return new Builder().exchangeAdapter(exchangeAdapter);
    }

    @Deprecated(since="6.1", forRemoval=true)
    public static Builder builder(HttpClientAdapter clientAdapter) {
        return new Builder().exchangeAdapter((HttpExchangeAdapter)clientAdapter.asReactorExchangeAdapter());
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class HttpServiceMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, ShadedHttpServiceMethod> httpServiceMethods;

        private HttpServiceMethodInterceptor(List<ShadedHttpServiceMethod> methods) {
            this.httpServiceMethods = methods.stream().collect(Collectors.toMap(ShadedHttpServiceMethod::getMethod, Function.identity()));
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            ShadedHttpServiceMethod httpServiceMethod = this.httpServiceMethods.get(method);
            if (httpServiceMethod != null) {
                if (KotlinDetector.isSuspendingFunction((Method)method)) {
                    return KotlinDelegate.invokeSuspendingFunction(invocation, httpServiceMethod);
                }
                return httpServiceMethod.invoke(invocation.getArguments());
            }
            if (method.isDefault() && invocation instanceof ReflectiveMethodInvocation) {
                ReflectiveMethodInvocation reflectiveMethodInvocation = (ReflectiveMethodInvocation)invocation;
                Object proxy = reflectiveMethodInvocation.getProxy();
                return InvocationHandler.invokeDefault(proxy, method, invocation.getArguments());
            }
            throw new IllegalStateException("Unexpected method invocation: " + method);
        }
    }

    public static final class Builder {
        @Nullable
        private HttpExchangeAdapter exchangeAdapter;
        private final List<HttpServiceArgumentResolver> customArgumentResolvers = new ArrayList<HttpServiceArgumentResolver>();
        @Nullable
        private ConversionService conversionService;
        @Nullable
        private StringValueResolver embeddedValueResolver;

        private Builder() {
        }

        public Builder exchangeAdapter(HttpExchangeAdapter adapter) {
            this.exchangeAdapter = adapter;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public Builder clientAdapter(HttpClientAdapter clientAdapter) {
            this.exchangeAdapter = clientAdapter.asReactorExchangeAdapter();
            return this;
        }

        public Builder customArgumentResolver(HttpServiceArgumentResolver resolver) {
            this.customArgumentResolvers.add(resolver);
            return this;
        }

        public Builder conversionService(ConversionService conversionService) {
            this.conversionService = conversionService;
            return this;
        }

        public Builder embeddedValueResolver(StringValueResolver embeddedValueResolver) {
            this.embeddedValueResolver = embeddedValueResolver;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public Builder reactiveAdapterRegistry(ReactiveAdapterRegistry registry) {
            HttpExchangeAdapter httpExchangeAdapter = this.exchangeAdapter;
            if (httpExchangeAdapter instanceof AbstractReactorHttpExchangeAdapter) {
                AbstractReactorHttpExchangeAdapter settable = (AbstractReactorHttpExchangeAdapter)httpExchangeAdapter;
                settable.setReactiveAdapterRegistry(registry);
            }
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public Builder blockTimeout(@Nullable Duration blockTimeout) {
            HttpExchangeAdapter httpExchangeAdapter = this.exchangeAdapter;
            if (httpExchangeAdapter instanceof AbstractReactorHttpExchangeAdapter) {
                AbstractReactorHttpExchangeAdapter settable = (AbstractReactorHttpExchangeAdapter)httpExchangeAdapter;
                settable.setBlockTimeout(blockTimeout);
            }
            return this;
        }

        public ShadedHttpServiceProxyFactory build() {
            Assert.notNull((Object)this.exchangeAdapter, (String)"HttpClientAdapter is required");
            return new ShadedHttpServiceProxyFactory(this.exchangeAdapter, this.initArgumentResolvers(), this.embeddedValueResolver);
        }

        private List<HttpServiceArgumentResolver> initArgumentResolvers() {
            ArrayList<HttpServiceArgumentResolver> resolvers = new ArrayList<HttpServiceArgumentResolver>(this.customArgumentResolvers);
            ConversionService service = this.conversionService != null ? this.conversionService : new DefaultFormattingConversionService();
            resolvers.add((HttpServiceArgumentResolver)new RequestHeaderArgumentResolver(service));
            resolvers.add((HttpServiceArgumentResolver)new RequestBodyArgumentResolver(this.exchangeAdapter));
            resolvers.add((HttpServiceArgumentResolver)new PathVariableArgumentResolver(service));
            resolvers.add((HttpServiceArgumentResolver)new RequestParamArgumentResolver(service));
            resolvers.add((HttpServiceArgumentResolver)new RequestPartArgumentResolver(this.exchangeAdapter));
            resolvers.add((HttpServiceArgumentResolver)new CookieValueArgumentResolver(service));
            if (this.exchangeAdapter.supportsRequestAttributes()) {
                resolvers.add((HttpServiceArgumentResolver)new RequestAttributeArgumentResolver());
            }
            resolvers.add((HttpServiceArgumentResolver)new UrlArgumentResolver());
            resolvers.add((HttpServiceArgumentResolver)new UriBuilderFactoryArgumentResolver());
            resolvers.add((HttpServiceArgumentResolver)new HttpMethodArgumentResolver());
            return resolvers;
        }
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        public static Object invokeSuspendingFunction(MethodInvocation invocation, ShadedHttpServiceMethod httpServiceMethod) {
            Object[] rawArguments = invocation.getArguments();
            Object[] arguments = KotlinDelegate.resolveArguments(rawArguments);
            Continuation continuation = (Continuation)rawArguments[rawArguments.length - 1];
            Mono wrapped = (Mono)httpServiceMethod.invoke(arguments);
            assert (wrapped != null);
            return MonoKt.awaitSingleOrNull((Mono)wrapped, (Continuation)continuation);
        }

        private static Object[] resolveArguments(Object[] args) {
            Object[] functionArgs = new Object[args.length - 1];
            System.arraycopy(args, 0, functionArgs, 0, args.length - 1);
            return functionArgs;
        }
    }
}

