/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielliu1123.httpexchange;

import io.github.danielliu1123.httpexchange.HttpExchangeProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.service.annotation.HttpExchange;

final class Util {
    private static final AntPathMatcher matcher = new AntPathMatcher(".");

    public static Optional<HttpExchangeProperties.Channel> findMatchedConfig(Class<?> clz, HttpExchangeProperties properties) {
        Optional<HttpExchangeProperties.Channel> found = properties.getChannels().stream().filter(it -> it.getClasses().stream().anyMatch(ch -> ch == clz)).findFirst();
        if (found.isPresent()) {
            return found;
        }
        return properties.getChannels().stream().filter(it -> Util.match(clz, it)).findFirst();
    }

    public static boolean nameMatch(String name, Set<Class<?>> classes) {
        return classes.stream().anyMatch(clz -> Util.match(name, clz));
    }

    private static boolean match(Class<?> clz, HttpExchangeProperties.Channel client) {
        if (client.getClasses().stream().anyMatch(ch -> ch == clz)) {
            return true;
        }
        return client.getClients().stream().anyMatch(name -> Util.match(name, clz));
    }

    private static boolean match(String name, Class<?> clz) {
        return Util.isMatched(name, clz) || Stream.of(clz.getInterfaces()).anyMatch(it -> Util.isMatched(name, it));
    }

    private static boolean isMatched(String name, Class<?> clz) {
        String nameToUse = name.replace("-", "");
        return nameToUse.equalsIgnoreCase(clz.getSimpleName()) || nameToUse.equalsIgnoreCase(clz.getName()) || nameToUse.equalsIgnoreCase(clz.getCanonicalName()) || matcher.match(name, clz.getCanonicalName()) || matcher.match(name, clz.getSimpleName());
    }

    public static HttpExchangeProperties getProperties(Environment environment) {
        HttpExchangeProperties properties = (HttpExchangeProperties)Binder.get((Environment)environment).bind("http-exchange", HttpExchangeProperties.class).orElseGet(HttpExchangeProperties::new);
        properties.afterPropertiesSet();
        return properties;
    }

    public static boolean isHttpExchangeInterface(Class<?> clz) {
        return clz.isInterface() && (Util.hasAnnotation(clz, HttpExchange.class) || Util.hasAnnotation(clz, RequestMapping.class));
    }

    public static boolean hasAnnotation(Class<?> clz, Class<? extends Annotation> annotationType) {
        Method[] methods;
        if (AnnotationUtils.findAnnotation(clz, annotationType) != null) {
            return true;
        }
        for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(clz)) {
            if (AnnotationUtils.findAnnotation((Method)method, annotationType) == null) continue;
            return true;
        }
        return false;
    }

    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

