/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielliu1123.httpexchange;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.StringValueResolver;

public class UrlPlaceholderStringValueResolver
implements StringValueResolver {
    private static final Logger log = LoggerFactory.getLogger(UrlPlaceholderStringValueResolver.class);
    private final Environment environment;
    @Nullable
    private final StringValueResolver delegate;

    public UrlPlaceholderStringValueResolver(Environment environment, @Nullable StringValueResolver delegate) {
        this.environment = environment;
        this.delegate = delegate;
    }

    public String resolveStringValue(@Nonnull String strVal) {
        String resolved = strVal;
        try {
            resolved = this.environment.resolvePlaceholders(strVal);
        }
        catch (Exception e) {
            log.warn("Placeholders in '{}' could not be resolved", (Object)strVal, (Object)e);
        }
        return this.delegate != null ? this.delegate.resolveStringValue(resolved) : resolved;
    }

    public static UrlPlaceholderStringValueResolver create(Environment environment, @Nullable StringValueResolver delegate) {
        return new UrlPlaceholderStringValueResolver(environment, delegate);
    }
}

