/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielliu1123.httpexchange;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;

@ConfigurationProperties(value="http-exchange")
public class HttpExchangeProperties
implements InitializingBean {
    public static final String PREFIX = "http-exchange";
    private boolean enabled = true;
    private Set<String> basePackages = new LinkedHashSet<String>();
    private Set<Class<?>> clients = new LinkedHashSet();
    private String baseUrl;
    private List<Header> headers = new ArrayList<Header>();
    private List<Channel> channels = new ArrayList<Channel>();
    private boolean beanToQueryEnabled = false;
    private Refresh refresh = new Refresh();
    private ClientType clientType;
    private boolean requestMappingSupportEnabled = false;
    private Integer connectTimeout;
    private Integer readTimeout;
    private boolean warnUnusedConfigEnabled = true;
    private boolean loadbalancerEnabled = true;
    private boolean httpClientReuseEnabled = true;

    public void afterPropertiesSet() {
        this.merge();
    }

    void merge() {
        PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        for (Channel chan : this.channels) {
            mapper.from((Object)this.baseUrl).when(e -> Objects.isNull(chan.getBaseUrl())).to(chan::setBaseUrl);
            mapper.from((Object)this.clientType).when(e -> Objects.isNull((Object)chan.getClientType())).to(chan::setClientType);
            mapper.from((Object)this.connectTimeout).when(e -> Objects.isNull(chan.getConnectTimeout())).to(chan::setConnectTimeout);
            mapper.from((Object)this.readTimeout).when(e -> Objects.isNull(chan.getReadTimeout())).to(chan::setReadTimeout);
            mapper.from((Object)this.loadbalancerEnabled).when(e -> Objects.isNull(chan.getLoadbalancerEnabled())).to(chan::setLoadbalancerEnabled);
            mapper.from((Object)this.httpClientReuseEnabled).when(e -> Objects.isNull(chan.getHttpClientReuseEnabled())).to(chan::setHttpClientReuseEnabled);
            LinkedHashMap total = this.headers.stream().collect(Collectors.toMap(Header::getKey, Header::getValues, (oldV, newV) -> oldV, LinkedHashMap::new));
            for (Header header : chan.getHeaders()) {
                total.put(header.getKey(), header.getValues());
            }
            List<Header> mergedHeaders = total.entrySet().stream().map(e -> new Header((String)e.getKey(), (List)e.getValue())).toList();
            chan.setHeaders(mergedHeaders);
        }
    }

    Channel defaultClient() {
        return new Channel(null, this.baseUrl, this.headers, this.clientType, this.connectTimeout, this.readTimeout, this.loadbalancerEnabled, this.httpClientReuseEnabled, List.of(), List.of());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Set<String> getBasePackages() {
        return this.basePackages;
    }

    public Set<Class<?>> getClients() {
        return this.clients;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public boolean isBeanToQueryEnabled() {
        return this.beanToQueryEnabled;
    }

    public Refresh getRefresh() {
        return this.refresh;
    }

    public ClientType getClientType() {
        return this.clientType;
    }

    public boolean isRequestMappingSupportEnabled() {
        return this.requestMappingSupportEnabled;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isWarnUnusedConfigEnabled() {
        return this.warnUnusedConfigEnabled;
    }

    public boolean isLoadbalancerEnabled() {
        return this.loadbalancerEnabled;
    }

    public boolean isHttpClientReuseEnabled() {
        return this.httpClientReuseEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBasePackages(Set<String> basePackages) {
        this.basePackages = basePackages;
    }

    public void setClients(Set<Class<?>> clients) {
        this.clients = clients;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    public void setBeanToQueryEnabled(boolean beanToQueryEnabled) {
        this.beanToQueryEnabled = beanToQueryEnabled;
    }

    public void setRefresh(Refresh refresh) {
        this.refresh = refresh;
    }

    public void setClientType(ClientType clientType) {
        this.clientType = clientType;
    }

    public void setRequestMappingSupportEnabled(boolean requestMappingSupportEnabled) {
        this.requestMappingSupportEnabled = requestMappingSupportEnabled;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setWarnUnusedConfigEnabled(boolean warnUnusedConfigEnabled) {
        this.warnUnusedConfigEnabled = warnUnusedConfigEnabled;
    }

    public void setLoadbalancerEnabled(boolean loadbalancerEnabled) {
        this.loadbalancerEnabled = loadbalancerEnabled;
    }

    public void setHttpClientReuseEnabled(boolean httpClientReuseEnabled) {
        this.httpClientReuseEnabled = httpClientReuseEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpExchangeProperties)) {
            return false;
        }
        HttpExchangeProperties other = (HttpExchangeProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isBeanToQueryEnabled() != other.isBeanToQueryEnabled()) {
            return false;
        }
        if (this.isRequestMappingSupportEnabled() != other.isRequestMappingSupportEnabled()) {
            return false;
        }
        if (this.isWarnUnusedConfigEnabled() != other.isWarnUnusedConfigEnabled()) {
            return false;
        }
        if (this.isLoadbalancerEnabled() != other.isLoadbalancerEnabled()) {
            return false;
        }
        if (this.isHttpClientReuseEnabled() != other.isHttpClientReuseEnabled()) {
            return false;
        }
        Integer this$connectTimeout = this.getConnectTimeout();
        Integer other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Integer this$readTimeout = this.getReadTimeout();
        Integer other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        Set<String> this$basePackages = this.getBasePackages();
        Set<String> other$basePackages = other.getBasePackages();
        if (this$basePackages == null ? other$basePackages != null : !((Object)this$basePackages).equals(other$basePackages)) {
            return false;
        }
        Set<Class<?>> this$clients = this.getClients();
        Set<Class<?>> other$clients = other.getClients();
        if (this$clients == null ? other$clients != null : !((Object)this$clients).equals(other$clients)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        List<Header> this$headers = this.getHeaders();
        List<Header> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        List<Channel> this$channels = this.getChannels();
        List<Channel> other$channels = other.getChannels();
        if (this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels)) {
            return false;
        }
        Refresh this$refresh = this.getRefresh();
        Refresh other$refresh = other.getRefresh();
        if (this$refresh == null ? other$refresh != null : !((Object)this$refresh).equals(other$refresh)) {
            return false;
        }
        ClientType this$clientType = this.getClientType();
        ClientType other$clientType = other.getClientType();
        return !(this$clientType == null ? other$clientType != null : !((Object)((Object)this$clientType)).equals((Object)other$clientType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpExchangeProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isBeanToQueryEnabled() ? 79 : 97);
        result = result * 59 + (this.isRequestMappingSupportEnabled() ? 79 : 97);
        result = result * 59 + (this.isWarnUnusedConfigEnabled() ? 79 : 97);
        result = result * 59 + (this.isLoadbalancerEnabled() ? 79 : 97);
        result = result * 59 + (this.isHttpClientReuseEnabled() ? 79 : 97);
        Integer $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Integer $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        Set<String> $basePackages = this.getBasePackages();
        result = result * 59 + ($basePackages == null ? 43 : ((Object)$basePackages).hashCode());
        Set<Class<?>> $clients = this.getClients();
        result = result * 59 + ($clients == null ? 43 : ((Object)$clients).hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        List<Header> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        List<Channel> $channels = this.getChannels();
        result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
        Refresh $refresh = this.getRefresh();
        result = result * 59 + ($refresh == null ? 43 : ((Object)$refresh).hashCode());
        ClientType $clientType = this.getClientType();
        result = result * 59 + ($clientType == null ? 43 : ((Object)((Object)$clientType)).hashCode());
        return result;
    }

    public String toString() {
        return "HttpExchangeProperties(enabled=" + this.isEnabled() + ", basePackages=" + this.getBasePackages() + ", clients=" + this.getClients() + ", baseUrl=" + this.getBaseUrl() + ", headers=" + this.getHeaders() + ", channels=" + this.getChannels() + ", beanToQueryEnabled=" + this.isBeanToQueryEnabled() + ", refresh=" + this.getRefresh() + ", clientType=" + this.getClientType() + ", requestMappingSupportEnabled=" + this.isRequestMappingSupportEnabled() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", warnUnusedConfigEnabled=" + this.isWarnUnusedConfigEnabled() + ", loadbalancerEnabled=" + this.isLoadbalancerEnabled() + ", httpClientReuseEnabled=" + this.isHttpClientReuseEnabled() + ")";
    }

    public static class Channel {
        private String name;
        private String baseUrl;
        private List<Header> headers = new ArrayList<Header>();
        private ClientType clientType;
        private Integer connectTimeout;
        private Integer readTimeout;
        private Boolean loadbalancerEnabled;
        private Boolean httpClientReuseEnabled;
        private List<String> clients = new ArrayList<String>();
        private List<Class<?>> classes = new ArrayList();

        public String getName() {
            return this.name;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public List<Header> getHeaders() {
            return this.headers;
        }

        public ClientType getClientType() {
            return this.clientType;
        }

        public Integer getConnectTimeout() {
            return this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return this.readTimeout;
        }

        public Boolean getLoadbalancerEnabled() {
            return this.loadbalancerEnabled;
        }

        public Boolean getHttpClientReuseEnabled() {
            return this.httpClientReuseEnabled;
        }

        public List<String> getClients() {
            return this.clients;
        }

        public List<Class<?>> getClasses() {
            return this.classes;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public void setHeaders(List<Header> headers) {
            this.headers = headers;
        }

        public void setClientType(ClientType clientType) {
            this.clientType = clientType;
        }

        public void setConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public void setReadTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
        }

        public void setLoadbalancerEnabled(Boolean loadbalancerEnabled) {
            this.loadbalancerEnabled = loadbalancerEnabled;
        }

        public void setHttpClientReuseEnabled(Boolean httpClientReuseEnabled) {
            this.httpClientReuseEnabled = httpClientReuseEnabled;
        }

        public void setClients(List<String> clients) {
            this.clients = clients;
        }

        public void setClasses(List<Class<?>> classes) {
            this.classes = classes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Channel)) {
                return false;
            }
            Channel other = (Channel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$connectTimeout = this.getConnectTimeout();
            Integer other$connectTimeout = other.getConnectTimeout();
            if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
                return false;
            }
            Integer this$readTimeout = this.getReadTimeout();
            Integer other$readTimeout = other.getReadTimeout();
            if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
                return false;
            }
            Boolean this$loadbalancerEnabled = this.getLoadbalancerEnabled();
            Boolean other$loadbalancerEnabled = other.getLoadbalancerEnabled();
            if (this$loadbalancerEnabled == null ? other$loadbalancerEnabled != null : !((Object)this$loadbalancerEnabled).equals(other$loadbalancerEnabled)) {
                return false;
            }
            Boolean this$httpClientReuseEnabled = this.getHttpClientReuseEnabled();
            Boolean other$httpClientReuseEnabled = other.getHttpClientReuseEnabled();
            if (this$httpClientReuseEnabled == null ? other$httpClientReuseEnabled != null : !((Object)this$httpClientReuseEnabled).equals(other$httpClientReuseEnabled)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$baseUrl = this.getBaseUrl();
            String other$baseUrl = other.getBaseUrl();
            if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
                return false;
            }
            List<Header> this$headers = this.getHeaders();
            List<Header> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            ClientType this$clientType = this.getClientType();
            ClientType other$clientType = other.getClientType();
            if (this$clientType == null ? other$clientType != null : !((Object)((Object)this$clientType)).equals((Object)other$clientType)) {
                return false;
            }
            List<String> this$clients = this.getClients();
            List<String> other$clients = other.getClients();
            if (this$clients == null ? other$clients != null : !((Object)this$clients).equals(other$clients)) {
                return false;
            }
            List<Class<?>> this$classes = this.getClasses();
            List<Class<?>> other$classes = other.getClasses();
            return !(this$classes == null ? other$classes != null : !((Object)this$classes).equals(other$classes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Channel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $connectTimeout = this.getConnectTimeout();
            result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
            Integer $readTimeout = this.getReadTimeout();
            result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
            Boolean $loadbalancerEnabled = this.getLoadbalancerEnabled();
            result = result * 59 + ($loadbalancerEnabled == null ? 43 : ((Object)$loadbalancerEnabled).hashCode());
            Boolean $httpClientReuseEnabled = this.getHttpClientReuseEnabled();
            result = result * 59 + ($httpClientReuseEnabled == null ? 43 : ((Object)$httpClientReuseEnabled).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $baseUrl = this.getBaseUrl();
            result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
            List<Header> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            ClientType $clientType = this.getClientType();
            result = result * 59 + ($clientType == null ? 43 : ((Object)((Object)$clientType)).hashCode());
            List<String> $clients = this.getClients();
            result = result * 59 + ($clients == null ? 43 : ((Object)$clients).hashCode());
            List<Class<?>> $classes = this.getClasses();
            result = result * 59 + ($classes == null ? 43 : ((Object)$classes).hashCode());
            return result;
        }

        public String toString() {
            return "HttpExchangeProperties.Channel(name=" + this.getName() + ", baseUrl=" + this.getBaseUrl() + ", headers=" + this.getHeaders() + ", clientType=" + this.getClientType() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", loadbalancerEnabled=" + this.getLoadbalancerEnabled() + ", httpClientReuseEnabled=" + this.getHttpClientReuseEnabled() + ", clients=" + this.getClients() + ", classes=" + this.getClasses() + ")";
        }

        public Channel() {
        }

        public Channel(String name, String baseUrl, List<Header> headers, ClientType clientType, Integer connectTimeout, Integer readTimeout, Boolean loadbalancerEnabled, Boolean httpClientReuseEnabled, List<String> clients, List<Class<?>> classes) {
            this.name = name;
            this.baseUrl = baseUrl;
            this.headers = headers;
            this.clientType = clientType;
            this.connectTimeout = connectTimeout;
            this.readTimeout = readTimeout;
            this.loadbalancerEnabled = loadbalancerEnabled;
            this.httpClientReuseEnabled = httpClientReuseEnabled;
            this.clients = clients;
            this.classes = classes;
        }
    }

    public static enum ClientType {
        REST_CLIENT,
        WEB_CLIENT,
        REST_TEMPLATE;

    }

    public static class Header {
        private String key;
        private List<String> values = new ArrayList<String>();

        public String getKey() {
            return this.key;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Header)) {
                return false;
            }
            Header other = (Header)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            List<String> this$values = this.getValues();
            List<String> other$values = other.getValues();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Header;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            List<String> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        public String toString() {
            return "HttpExchangeProperties.Header(key=" + this.getKey() + ", values=" + this.getValues() + ")";
        }

        public Header() {
        }

        public Header(String key, List<String> values) {
            this.key = key;
            this.values = values;
        }
    }

    public static class Refresh {
        public static final String PREFIX = "http-exchange.refresh";
        private boolean enabled = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Refresh)) {
                return false;
            }
            Refresh other = (Refresh)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isEnabled() == other.isEnabled();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Refresh;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "HttpExchangeProperties.Refresh(enabled=" + this.isEnabled() + ")";
        }
    }
}

