/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielliu1123.httpexchange;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.danielliu1123.httpexchange.Cache;
import io.github.danielliu1123.httpexchange.HttpExchangeProperties;
import io.github.danielliu1123.httpexchange.HttpServiceProxyFactoryCustomizer;
import io.github.danielliu1123.httpexchange.UrlPlaceholderStringValueResolver;
import io.github.danielliu1123.httpexchange.Util;
import io.github.danielliu1123.httpexchange.shaded.ShadedHttpServiceProxyFactory;
import io.github.danielliu1123.httpexchange.shaded.requestfactory.EnhancedJdkClientHttpRequestFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.web.client.RestClientBuilderConfigurer;
import org.springframework.boot.autoconfigure.web.client.RestTemplateBuilderConfigurer;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.web.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.boot.web.reactive.function.client.WebClientCustomizer;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancedExchangeFilterFunction;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.Environment;
import org.springframework.http.client.AbstractClientHttpRequestFactoryWrapper;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.support.RestClientAdapter;
import org.springframework.web.client.support.RestTemplateAdapter;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.support.WebClientAdapter;
import org.springframework.web.service.annotation.HttpExchange;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceProxyFactory;

class ExchangeClientCreator {
    private static final Logger log = LoggerFactory.getLogger(ExchangeClientCreator.class);
    private static final boolean WEBFLUX_PRESENT = ClassUtils.isPresent((String)"org.springframework.web.reactive.function.client.WebClient", null);
    private static final boolean LOADBALANCER_PRESENT = ClassUtils.isPresent((String)"org.springframework.cloud.client.loadbalancer.LoadBalancerClient", null);
    private static final Field exchangeAdapterField;
    private static final Field customArgumentResolversField;
    private static final Field conversionServiceField;
    private static final Field embeddedValueResolverField;
    private final BeanFactory beanFactory;
    private final Environment environment;
    private final Class<?> clientType;
    private final boolean isUseHttpExchangeAnnotation;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public ExchangeClientCreator(BeanFactory beanFactory, Class<?> clientType) {
        this.beanFactory = beanFactory;
        this.environment = (Environment)beanFactory.getBean(Environment.class);
        Assert.isTrue((boolean)clientType.isInterface(), () -> clientType + " is not an interface");
        this.clientType = clientType;
        Assert.isTrue((boolean)Util.isHttpExchangeInterface(clientType), () -> clientType + " is not a HttpExchange client");
        this.isUseHttpExchangeAnnotation = Util.hasAnnotation(clientType, HttpExchange.class);
    }

    public <T> T create() {
        HttpExchangeProperties httpExchangeProperties = (HttpExchangeProperties)this.beanFactory.getBeanProvider(HttpExchangeProperties.class).getIfUnique(() -> Util.getProperties(this.environment));
        HttpExchangeProperties.Channel chan = Util.findMatchedConfig(this.clientType, httpExchangeProperties).orElseGet(httpExchangeProperties::defaultClient);
        if (this.isUseHttpExchangeAnnotation) {
            HttpServiceProxyFactory factory = this.factoryBuilder(chan).build();
            Object result = factory.createClient(this.clientType);
            Cache.addClient(result);
            return (T)result;
        }
        if (!httpExchangeProperties.isRequestMappingSupportEnabled()) {
            throw new IllegalStateException(this.clientType + " is using the @RequestMapping based annotation, please migrate to @HttpExchange, or set 'http-exchange.request-mapping-support-enabled=true' to enable support for processing @RequestMapping");
        }
        ShadedHttpServiceProxyFactory shadedFactory = ExchangeClientCreator.shadedProxyFactory(this.factoryBuilder(chan)).build();
        Object result = shadedFactory.createClient(this.clientType);
        Cache.addClient(result);
        return (T)result;
    }

    private HttpServiceProxyFactory.Builder factoryBuilder(HttpExchangeProperties.Channel channelConfig) {
        HttpServiceProxyFactory.Builder builder = HttpServiceProxyFactory.builder();
        this.beanFactory.getBeanProvider(HttpServiceProxyFactoryCustomizer.class).orderedStream().forEach(customizer -> customizer.customize(builder));
        this.setExchangeAdapter(builder, channelConfig);
        this.setEmbeddedValueResolver(builder);
        this.addCustomArgumentResolver(builder);
        return builder;
    }

    private void setExchangeAdapter(HttpServiceProxyFactory.Builder builder, HttpExchangeProperties.Channel channelConfig) {
        if (WEBFLUX_PRESENT && ExchangeClientCreator.hasReactiveReturnTypeMethod(this.clientType)) {
            HttpExchangeProperties.ClientType type = channelConfig.getClientType();
            if (type != null && type != HttpExchangeProperties.ClientType.WEB_CLIENT) {
                log.warn("{} contains methods with reactive return types, should use the client-type '{}' instead of '{}'", new Object[]{this.clientType.getSimpleName(), HttpExchangeProperties.ClientType.WEB_CLIENT, type});
            }
            builder.exchangeAdapter((HttpExchangeAdapter)WebClientAdapter.create((WebClient)ExchangeClientCreator.getClient(new Cache.ClientId(channelConfig, HttpExchangeProperties.ClientType.WEB_CLIENT), () -> this.buildWebClient(channelConfig))));
            return;
        }
        switch (ExchangeClientCreator.getClientType(channelConfig)) {
            case REST_CLIENT: {
                builder.exchangeAdapter((HttpExchangeAdapter)RestClientAdapter.create((RestClient)ExchangeClientCreator.getClient(new Cache.ClientId(channelConfig, HttpExchangeProperties.ClientType.REST_CLIENT), () -> this.buildRestClient(channelConfig))));
                break;
            }
            case REST_TEMPLATE: {
                builder.exchangeAdapter((HttpExchangeAdapter)RestTemplateAdapter.create((RestTemplate)ExchangeClientCreator.getClient(new Cache.ClientId(channelConfig, HttpExchangeProperties.ClientType.REST_TEMPLATE), () -> this.buildRestTemplate(channelConfig))));
                break;
            }
            case WEB_CLIENT: {
                if (WEBFLUX_PRESENT) {
                    builder.exchangeAdapter((HttpExchangeAdapter)WebClientAdapter.create((WebClient)ExchangeClientCreator.getClient(new Cache.ClientId(channelConfig, HttpExchangeProperties.ClientType.WEB_CLIENT), () -> this.buildWebClient(channelConfig))));
                    break;
                }
                log.warn("Since spring-webflux is not in the classpath, the client-type will fall back to '{}'", (Object)HttpExchangeProperties.ClientType.REST_CLIENT);
                builder.exchangeAdapter((HttpExchangeAdapter)RestClientAdapter.create((RestClient)ExchangeClientCreator.getClient(new Cache.ClientId(channelConfig, HttpExchangeProperties.ClientType.REST_CLIENT), () -> this.buildRestClient(channelConfig))));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported client-type: " + channelConfig.getClientType());
            }
        }
    }

    private static <T> T getClient(Cache.ClientId clientId, Supplier<T> supplier) {
        return Boolean.TRUE.equals(clientId.channel().getHttpClientReuseEnabled()) ? Cache.getHttpClient(clientId, supplier) : supplier.get();
    }

    private void addCustomArgumentResolver(HttpServiceProxyFactory.Builder builder) {
        List existingResolvers = (List)ExchangeClientCreator.getFieldValue((Object)builder, customArgumentResolversField);
        this.beanFactory.getBeanProvider(HttpServiceArgumentResolver.class).orderedStream().filter(resolver -> !existingResolvers.contains(resolver)).forEach(arg_0 -> ((HttpServiceProxyFactory.Builder)builder).customArgumentResolver(arg_0));
    }

    private void setEmbeddedValueResolver(HttpServiceProxyFactory.Builder builder) {
        StringValueResolver resolver = Optional.ofNullable(ExchangeClientCreator.getFieldValue((Object)builder, embeddedValueResolverField)).map(StringValueResolver.class::cast).map(r -> UrlPlaceholderStringValueResolver.create(this.environment, r)).orElseGet(() -> UrlPlaceholderStringValueResolver.create(this.environment, null));
        builder.embeddedValueResolver(resolver);
    }

    private RestTemplate buildRestTemplate(HttpExchangeProperties.Channel channelConfig) {
        RestTemplateBuilder builder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        RestTemplateBuilderConfigurer configurer = (RestTemplateBuilderConfigurer)this.beanFactory.getBeanProvider(RestTemplateBuilderConfigurer.class).getIfUnique();
        if (configurer != null) {
            builder = configurer.configure(builder);
        }
        if (StringUtils.hasText((String)channelConfig.getBaseUrl())) {
            builder = builder.rootUri(ExchangeClientCreator.getRealBaseUrl(channelConfig));
        }
        if (!CollectionUtils.isEmpty(channelConfig.getHeaders())) {
            for (HttpExchangeProperties.Header header : channelConfig.getHeaders()) {
                builder = builder.defaultHeader(header.getKey(), (String[])header.getValues().toArray(String[]::new));
            }
        }
        builder = builder.requestFactory(() -> this.getRequestFactory(channelConfig));
        if (this.isLoadBalancerEnabled(channelConfig)) {
            List interceptors = this.beanFactory.getBeanProvider(ClientHttpRequestInterceptor.class).orderedStream().toList();
            builder = builder.additionalInterceptors(interceptors);
        }
        RestTemplate restTemplate = builder.build();
        restTemplate.setInterceptors(restTemplate.getInterceptors().stream().distinct().toList());
        ExchangeClientCreator.setTimeoutByConfig(restTemplate.getRequestFactory(), channelConfig);
        return restTemplate;
    }

    private WebClient buildWebClient(HttpExchangeProperties.Channel channelConfig) {
        WebClient.Builder builder = WebClient.builder();
        this.beanFactory.getBeanProvider(WebClientCustomizer.class).orderedStream().forEach(customizer -> customizer.customize(builder));
        if (StringUtils.hasText((String)channelConfig.getBaseUrl())) {
            builder.baseUrl(ExchangeClientCreator.getRealBaseUrl(channelConfig));
        }
        if (!CollectionUtils.isEmpty(channelConfig.getHeaders())) {
            channelConfig.getHeaders().forEach(header -> builder.defaultHeader(header.getKey(), (String[])header.getValues().toArray(String[]::new)));
        }
        if (channelConfig.getReadTimeout() != null) {
            builder.filter((request, next) -> next.exchange(request).timeout(Duration.ofMillis(channelConfig.getReadTimeout().intValue())));
        }
        if (this.isLoadBalancerEnabled(channelConfig)) {
            builder.filters(filters -> {
                List<ExchangeFilterFunction> newFilters = this.beanFactory.getBeanProvider(ExchangeFilterFunction.class).stream().filter(ExchangeClientCreator::notLoadBalancedFilter).toList();
                LinkedHashSet<ExchangeFilterFunction> allFilters = new LinkedHashSet<ExchangeFilterFunction>((Collection<ExchangeFilterFunction>)filters);
                allFilters.addAll(newFilters);
                filters.clear();
                filters.addAll(allFilters);
                AnnotationAwareOrderComparator.sort((List)filters);
            });
        }
        return builder.build();
    }

    private RestClient buildRestClient(HttpExchangeProperties.Channel channelConfig) {
        ClientHttpRequestFactory requestFactory;
        RestClient.Builder builder = RestClient.builder();
        this.beanFactory.getBeanProvider(RestClientBuilderConfigurer.class).ifUnique(configurer -> configurer.configure(builder));
        if (StringUtils.hasText((String)channelConfig.getBaseUrl())) {
            builder.baseUrl(ExchangeClientCreator.getRealBaseUrl(channelConfig));
        }
        if (!CollectionUtils.isEmpty(channelConfig.getHeaders())) {
            channelConfig.getHeaders().forEach(header -> builder.defaultHeader(header.getKey(), (String[])header.getValues().toArray(String[]::new)));
        }
        if ((requestFactory = ExchangeClientCreator.unwrapRequestFactoryIfNecessary((ClientHttpRequestFactory)ExchangeClientCreator.getFieldValue((Object)builder, "requestFactory"))) == null) {
            builder.requestFactory(this.getRequestFactory(channelConfig));
        } else {
            ExchangeClientCreator.setTimeoutByConfig(requestFactory, channelConfig);
        }
        if (this.isLoadBalancerEnabled(channelConfig)) {
            builder.requestInterceptors(interceptors -> {
                List newInterceptors = this.beanFactory.getBeanProvider(ClientHttpRequestInterceptor.class).stream().toList();
                LinkedHashSet allInterceptors = new LinkedHashSet(interceptors);
                allInterceptors.addAll(newInterceptors);
                interceptors.clear();
                interceptors.addAll(allInterceptors);
                AnnotationAwareOrderComparator.sort((List)interceptors);
            });
        }
        return builder.build();
    }

    private static boolean notLoadBalancedFilter(ExchangeFilterFunction e) {
        return !LoadBalancedExchangeFilterFunction.class.isAssignableFrom(e.getClass());
    }

    private ClientHttpRequestFactory getRequestFactory(HttpExchangeProperties.Channel channelConfig) {
        ClientHttpRequestFactorySettings settings = new ClientHttpRequestFactorySettings((Duration)Optional.ofNullable(channelConfig.getConnectTimeout()).map(Duration::ofMillis).orElse(null), (Duration)Optional.ofNullable(channelConfig.getReadTimeout()).map(Duration::ofMillis).orElse(null), (SslBundle)null);
        return ExchangeClientCreator.createEnhancedJdkClientHttpRequestFactory(settings);
    }

    private boolean isLoadBalancerEnabled(HttpExchangeProperties.Channel channelConfig) {
        return LOADBALANCER_PRESENT && (Boolean)this.environment.getProperty("spring.cloud.loadbalancer.enabled", Boolean.class, (Object)true) != false && channelConfig.getLoadbalancerEnabled() != false;
    }

    private static String getRealBaseUrl(HttpExchangeProperties.Channel channelConfig) {
        String baseUrl = channelConfig.getBaseUrl();
        return baseUrl.contains("://") ? baseUrl : "http://" + baseUrl;
    }

    static ShadedHttpServiceProxyFactory.Builder shadedProxyFactory(HttpServiceProxyFactory.Builder proxyFactory) {
        HttpExchangeAdapter exchangeAdapter = (HttpExchangeAdapter)ExchangeClientCreator.getFieldValue((Object)proxyFactory, exchangeAdapterField);
        List customArgumentResolvers = (List)ExchangeClientCreator.getFieldValue((Object)proxyFactory, customArgumentResolversField);
        ConversionService conversionService = (ConversionService)ExchangeClientCreator.getFieldValue((Object)proxyFactory, conversionServiceField);
        StringValueResolver embeddedValueResolver = (StringValueResolver)ExchangeClientCreator.getFieldValue((Object)proxyFactory, embeddedValueResolverField);
        ShadedHttpServiceProxyFactory.Builder builder = ShadedHttpServiceProxyFactory.builder();
        Optional.ofNullable(exchangeAdapter).ifPresent(builder::exchangeAdapter);
        Optional.ofNullable(customArgumentResolvers).stream().flatMap(Collection::stream).forEach(builder::customArgumentResolver);
        Optional.ofNullable(conversionService).ifPresent(builder::conversionService);
        Optional.ofNullable(embeddedValueResolver).ifPresent(builder::embeddedValueResolver);
        return builder;
    }

    static boolean hasReactiveReturnTypeMethod(Class<?> clz) {
        return Arrays.stream(ReflectionUtils.getAllDeclaredMethods(clz)).filter(method -> AnnotationUtils.findAnnotation((Method)method, HttpExchange.class) != null || AnnotationUtils.findAnnotation((Method)method, RequestMapping.class) != null).map(Method::getReturnType).anyMatch(returnType -> Publisher.class.isAssignableFrom((Class<?>)returnType) || Flow.Publisher.class.isAssignableFrom((Class<?>)returnType));
    }

    private static HttpExchangeProperties.ClientType getClientType(HttpExchangeProperties.Channel channel) {
        return channel.getClientType() != null ? channel.getClientType() : HttpExchangeProperties.ClientType.REST_CLIENT;
    }

    private static ClientHttpRequestFactory unwrapRequestFactoryIfNecessary(ClientHttpRequestFactory requestFactory) {
        if (!(requestFactory instanceof AbstractClientHttpRequestFactoryWrapper)) {
            return requestFactory;
        }
        Field field = ReflectionUtils.findField(AbstractClientHttpRequestFactoryWrapper.class, (String)"requestFactory");
        Assert.notNull((Object)field, (String)("requestFactory field not found in " + requestFactory.getClass().getName()));
        ReflectionUtils.makeAccessible((Field)field);
        ClientHttpRequestFactory unwrappedRequestFactory = requestFactory;
        while (unwrappedRequestFactory instanceof AbstractClientHttpRequestFactoryWrapper) {
            unwrappedRequestFactory = (ClientHttpRequestFactory)ReflectionUtils.getField((Field)field, (Object)unwrappedRequestFactory);
        }
        return unwrappedRequestFactory;
    }

    private static void setTimeoutByConfig(ClientHttpRequestFactory requestFactory, HttpExchangeProperties.Channel channelConfig) {
        ClientHttpRequestFactory realRequestFactory = ExchangeClientCreator.unwrapRequestFactoryIfNecessary(requestFactory);
        if (realRequestFactory == null) {
            return;
        }
        Optional.ofNullable(channelConfig.getReadTimeout()).ifPresent(readTimeout -> ExchangeClientCreator.setTimeout(realRequestFactory, "setReadTimeout", readTimeout));
        Optional.ofNullable(channelConfig.getConnectTimeout()).ifPresent(connectTimeout -> ExchangeClientCreator.setTimeout(realRequestFactory, "setConnectTimeout", connectTimeout));
    }

    private static void setTimeout(ClientHttpRequestFactory requestFactory, String method, int timeout) {
        if (!(ExchangeClientCreator.trySetTimeout(requestFactory, method, Integer.TYPE, timeout) || ExchangeClientCreator.trySetTimeout(requestFactory, method, Duration.class, Duration.ofMillis(timeout)) || ExchangeClientCreator.trySetTimeout(requestFactory, method, Long.TYPE, timeout))) {
            log.warn("ClientHttpRequestFactory implementation {} not provide a method '{}' to modify the timeout", (Object)requestFactory.getClass().getName(), (Object)method);
        }
    }

    private static boolean trySetTimeout(ClientHttpRequestFactory requestFactory, String method, Class<?> paramType, Object paramValue) {
        Method m = ReflectionUtils.findMethod(requestFactory.getClass(), (String)method, (Class[])new Class[]{paramType});
        if (m != null) {
            ReflectionUtils.makeAccessible((Method)m);
            ReflectionUtils.invokeMethod((Method)m, (Object)requestFactory, (Object[])new Object[]{paramValue});
            return true;
        }
        return false;
    }

    private static EnhancedJdkClientHttpRequestFactory createEnhancedJdkClientHttpRequestFactory(ClientHttpRequestFactorySettings settings) {
        HttpClient httpClient = ExchangeClientCreator.createHttpClient(settings.connectTimeout(), settings.sslBundle());
        EnhancedJdkClientHttpRequestFactory requestFactory = new EnhancedJdkClientHttpRequestFactory(httpClient);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(() -> ((ClientHttpRequestFactorySettings)settings).readTimeout()).to(requestFactory::setReadTimeout);
        return requestFactory;
    }

    private static HttpClient createHttpClient(Duration connectTimeout, SslBundle sslBundle) {
        HttpClient.Builder builder = HttpClient.newBuilder();
        if (connectTimeout != null) {
            builder.connectTimeout(connectTimeout);
        }
        if (sslBundle != null) {
            builder.sslContext(sslBundle.createSslContext());
        }
        return builder.build();
    }

    private static <T> T getFieldValue(Object obj, Field field) {
        ReflectionUtils.makeAccessible((Field)field);
        return (T)ReflectionUtils.getField((Field)field, (Object)obj);
    }

    private static <T> T getFieldValue(Object obj, String fieldName) {
        Field field = ReflectionUtils.findField(obj.getClass(), (String)fieldName);
        if (field == null) {
            return null;
        }
        return ExchangeClientCreator.getFieldValue(obj, field);
    }

    static {
        try {
            Class<HttpServiceProxyFactory.Builder> clz = HttpServiceProxyFactory.Builder.class;
            exchangeAdapterField = clz.getDeclaredField("exchangeAdapter");
            customArgumentResolversField = clz.getDeclaredField("customArgumentResolvers");
            conversionServiceField = clz.getDeclaredField("conversionService");
            embeddedValueResolverField = clz.getDeclaredField("embeddedValueResolver");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }
}

