/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.util;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.Beta;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Throwables;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.reflect.TypeToken;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

@Beta
public final class TypeTokenUtils {
    private static final Method IS_SUPERTYPE_OF_TYPE;
    private static final Method IS_SUPERTYPE_OF_TYPETOKEN;

    private TypeTokenUtils() {
        throw new AssertionError((Object)"intentionally not implemented");
    }

    public static <C> boolean isSupertypeOf(TypeToken<C> token, Type type) {
        try {
            return (Boolean)IS_SUPERTYPE_OF_TYPE.invoke(token, type);
        }
        catch (IllegalAccessException iae) {
            throw Throwables.propagate(iae);
        }
        catch (InvocationTargetException ite) {
            throw Throwables.propagate(ite);
        }
    }

    public static <C, D> boolean isSupertypeOf(TypeToken<C> token, TypeToken<D> token2) {
        try {
            return (Boolean)IS_SUPERTYPE_OF_TYPETOKEN.invoke(token, token2);
        }
        catch (IllegalAccessException iae) {
            throw Throwables.propagate(iae);
        }
        catch (InvocationTargetException ite) {
            throw Throwables.propagate(ite);
        }
    }

    static {
        Method isSuperTypeOfTypeToken;
        Method isSuperTypeOfType;
        try {
            isSuperTypeOfType = TypeToken.class.getDeclaredMethod("isSupertypeOf", Type.class);
            isSuperTypeOfTypeToken = TypeToken.class.getDeclaredMethod("isSupertypeOf", TypeToken.class);
        }
        catch (NoSuchMethodException nsme) {
            try {
                isSuperTypeOfType = TypeToken.class.getDeclaredMethod("isAssignableFrom", Type.class);
                isSuperTypeOfTypeToken = TypeToken.class.getDeclaredMethod("isAssignableFrom", TypeToken.class);
            }
            catch (NoSuchMethodException nsme2) {
                throw Throwables.propagate(nsme2);
            }
        }
        IS_SUPERTYPE_OF_TYPE = isSuperTypeOfType;
        IS_SUPERTYPE_OF_TYPETOKEN = isSuperTypeOfTypeToken;
    }
}

