/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.suppliers;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Suppliers;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableListMultimap;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Iterables;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Maps;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Multimaps;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.Resource;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;
import java.util.Collection;
import java.util.Map;

public class SupplyKeyMatchingValueOrNull<K, V>
implements Supplier<K> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Supplier<Map<K, Supplier<V>>> supplier;
    private final Supplier<V> valueSupplier;

    public SupplyKeyMatchingValueOrNull(Supplier<Map<K, Supplier<V>>> supplier, Supplier<V> valueSupplier) {
        this.valueSupplier = valueSupplier;
        this.supplier = supplier;
    }

    @Override
    public K get() {
        V uri = this.valueSupplier.get();
        final Map map = Maps.transformValues(this.supplier.get(), Suppliers.supplierFunction());
        ImmutableListMultimap<V, V> inverted = Multimaps.index(map.keySet(), new Function<K, V>(){

            @Override
            public V apply(K input) {
                return map.get(input);
            }
        });
        Collection keys = inverted.get(uri);
        K key = null;
        if (keys == null || keys.isEmpty()) {
            if (!map.isEmpty()) {
                key = Iterables.get(map.keySet(), 0);
                this.logger.warn("failed to find key for value %s in %s; choosing first: %s", uri, map, key);
            }
        } else {
            key = (K)Iterables.get(keys, 0);
            if (keys.size() > 1) {
                this.logger.debug("found %s keys for value %s. choosing first: %s", keys.size(), uri, key);
            }
        }
        return key;
    }
}

