/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.binders;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Strings;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequest;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.io.MutableContentMetadata;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.Binder;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.binders.BindException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.xml.XMLParser;
import java.io.IOException;

@Singleton
public class BindToXMLPayload
implements Binder {
    protected final XMLParser xmlParser;

    @Inject
    public BindToXMLPayload(XMLParser xmlParser) {
        this.xmlParser = Preconditions.checkNotNull(xmlParser, "xmlParser");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        try {
            String xml = this.xmlParser.toXML(Preconditions.checkNotNull(input, "input"));
            request.setPayload(xml);
            MutableContentMetadata metadata = request.getPayload().getContentMetadata();
            if (BindToXMLPayload.contentTypeMustBeAdded(metadata)) {
                metadata.setContentType("application/xml");
            }
            return request;
        }
        catch (IOException ex) {
            throw new BindException(request, (Throwable)ex);
        }
    }

    private static boolean contentTypeMustBeAdded(MutableContentMetadata metadata) {
        return Strings.isNullOrEmpty(metadata.getContentType()) || metadata.getContentType().equals("application/unknown");
    }
}

