/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Iterables;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Lists;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.reflect.Parameter;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Injector;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.predicates.Validator;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.reflect.Invocation;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.ParamValidators;
import java.util.ArrayList;
import java.util.List;

public class InputParamValidator {
    private final Injector injector;

    @Inject
    public InputParamValidator(Injector injector) {
        this.injector = injector;
    }

    public InputParamValidator() {
        this.injector = null;
    }

    public void validateMethodParametersOrThrow(Invocation invocation, List<Parameter> parameters) {
        try {
            this.performMethodValidation(Preconditions.checkNotNull(invocation, "invocation"));
            this.performParameterValidation(invocation, Preconditions.checkNotNull(parameters, "parameters"));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Validation on '%s' didn't pass:%n Reason: %s.", parameters, e.getMessage()), e);
        }
    }

    private void performMethodValidation(Invocation invocation) {
        ParamValidators paramValidatorsAnnotation = invocation.getInvokable().getAnnotation(ParamValidators.class);
        if (paramValidatorsAnnotation == null) {
            return;
        }
        List<Validator<?>> methodValidators = this.getValidatorsFromAnnotation(paramValidatorsAnnotation);
        this.runPredicatesAgainstArgs(methodValidators, invocation.getArgs());
    }

    private void performParameterValidation(Invocation invocation, List<Parameter> parameters) {
        for (Parameter param : parameters) {
            ParamValidators annotation = param.getAnnotation(ParamValidators.class);
            if (annotation == null) continue;
            List<Validator<?>> parameterValidators = this.getValidatorsFromAnnotation(annotation);
            this.runPredicatesAgainstArg(parameterValidators, invocation.getArgs().get(param.hashCode()));
        }
    }

    private List<Validator<?>> getValidatorsFromAnnotation(ParamValidators paramValidatorsAnnotation) {
        ArrayList<Validator<?>> validators = Lists.newArrayList();
        for (Class<? extends Validator<?>> validator : paramValidatorsAnnotation.value()) {
            validators.add(Preconditions.checkNotNull(this.injector.getInstance(validator)));
        }
        return validators;
    }

    private void runPredicatesAgainstArg(List<Validator<?>> predicates, Object arg) {
        for (Validator<?> validator : predicates) {
            validator.apply(arg);
        }
    }

    private void runPredicatesAgainstArgs(List<Validator<?>> predicates, List<Object> args) {
        for (Validator<?> validator : predicates) {
            Iterables.all(args, validator);
        }
    }
}

