/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.providers.internal;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.MoreObjects;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Objects;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Optional;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableSet;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Iterables;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Sets;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.apis.ApiMetadata;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.javax.annotation.Nullable;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.providers.ProviderMetadata;
import java.net.URI;
import java.util.Properties;
import java.util.Set;

public abstract class BaseProviderMetadata
implements ProviderMetadata {
    protected final String id;
    protected final String name;
    protected final ApiMetadata api;
    protected final String endpoint;
    protected final Properties defaultProperties;
    protected final Optional<URI> homepage;
    protected final Optional<URI> console;
    protected final Set<String> linkedServices;
    protected final Set<String> iso3166Codes;

    @Override
    public ProviderMetadata.Builder toBuilder() {
        return new Builder().fromProviderMetadata(this);
    }

    public BaseProviderMetadata(Builder builder) {
        this(builder.id, builder.name, builder.api, builder.endpoint, builder.defaultProperties, Optional.fromNullable(builder.homepage), Optional.fromNullable(builder.console), builder.linkedServices, builder.iso3166Codes);
    }

    public BaseProviderMetadata(String id, String name, ApiMetadata api, String endpoint, Properties defaultProperties, Optional<URI> homepage, Optional<URI> console, Set<String> linkedServices, Set<String> iso3166Codes) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = Preconditions.checkNotNull(name, "name");
        this.api = Preconditions.checkNotNull(api, "api");
        this.endpoint = Preconditions.checkNotNull(endpoint, "endpoint");
        this.console = Preconditions.checkNotNull(console, "console");
        this.defaultProperties = Preconditions.checkNotNull(defaultProperties, "defaultProperties");
        this.homepage = Preconditions.checkNotNull(homepage, "homepage");
        this.linkedServices = ImmutableSet.copyOf(linkedServices);
        this.iso3166Codes = ImmutableSet.copyOf(iso3166Codes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ProviderMetadata)) {
            return false;
        }
        ProviderMetadata that = (ProviderMetadata)ProviderMetadata.class.cast(o);
        return Objects.equal(this.getId(), that.getId()) && Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getApiMetadata(), that.getApiMetadata()) && Objects.equal(this.getEndpoint(), that.getEndpoint());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId(), this.getName(), this.getApiMetadata(), this.getEndpoint());
    }

    public String toString() {
        return this.string().toString();
    }

    public MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper("").add("id", this.getId()).add("name", this.getName()).add("api", this.getApiMetadata()).add("endpoint", this.getEndpoint()).add("console", this.getConsole()).add("homepage", this.getHomepage()).add("linkedServices", this.getLinkedServices()).add("iso3166Codes", this.getIso3166Codes());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ApiMetadata getApiMetadata() {
        return this.api;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Optional<URI> getConsole() {
        return this.console;
    }

    @Override
    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public Optional<URI> getHomepage() {
        return this.homepage;
    }

    @Override
    public Set<String> getLinkedServices() {
        return this.linkedServices;
    }

    @Override
    public Set<String> getIso3166Codes() {
        return this.iso3166Codes;
    }

    public static class Builder
    implements ProviderMetadata.Builder {
        protected String id;
        protected String name;
        protected ApiMetadata api;
        protected String endpoint;
        protected Properties defaultProperties = new Properties();
        protected URI console;
        protected URI homepage;
        protected Set<String> linkedServices = Sets.newLinkedHashSet();
        protected Set<String> iso3166Codes = Sets.newLinkedHashSet();

        @Override
        public Builder id(String id) {
            this.id = Preconditions.checkNotNull(id, "id");
            return this.linkedService(id);
        }

        @Override
        public Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            return this;
        }

        @Override
        public Builder apiMetadata(ApiMetadata api) {
            this.api = Preconditions.checkNotNull(api, "api");
            if (this.endpoint == null) {
                this.endpoint = api.getDefaultEndpoint().orNull();
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = Preconditions.checkNotNull(endpoint, "endpoint");
            return this;
        }

        @Override
        public Builder defaultProperties(Properties defaultProperties) {
            this.defaultProperties = Preconditions.checkNotNull(defaultProperties, "defaultProperties");
            return this;
        }

        @Override
        public Builder console(@Nullable URI console) {
            this.console = console;
            return this;
        }

        @Override
        public Builder homepage(URI homepage) {
            this.homepage = homepage;
            return this;
        }

        @Override
        public Builder linkedServices(Iterable<String> linkedServices) {
            Iterables.addAll(this.linkedServices, Preconditions.checkNotNull(linkedServices, "linkedServices"));
            return this;
        }

        @Override
        public Builder linkedServices(String ... linkedServices) {
            return this.linkedServices(ImmutableSet.copyOf(Preconditions.checkNotNull(linkedServices, "linkedServices")));
        }

        @Override
        public Builder linkedService(String linkedService) {
            this.linkedServices.add(Preconditions.checkNotNull(linkedService, "linkedService"));
            return this;
        }

        @Override
        public Builder iso3166Codes(Iterable<String> iso3166Codes) {
            Iterables.addAll(this.iso3166Codes, Preconditions.checkNotNull(iso3166Codes, "iso3166Codes"));
            return this;
        }

        @Override
        public Builder iso3166Codes(String ... iso3166Codes) {
            return this.iso3166Codes(ImmutableSet.copyOf(Preconditions.checkNotNull(iso3166Codes, "iso3166Codes")));
        }

        @Override
        public Builder iso3166Code(String iso3166Code) {
            this.iso3166Codes.add(Preconditions.checkNotNull(iso3166Code, "iso3166Code"));
            return this;
        }

        @Override
        public Builder fromProviderMetadata(ProviderMetadata in) {
            return ((Builder)this.id(in.getId()).name(in.getName()).apiMetadata(in.getApiMetadata()).endpoint(in.getEndpoint()).defaultProperties(in.getDefaultProperties()).console(in.getConsole().orNull()).homepage(in.getHomepage().orNull()).linkedServices(in.getLinkedServices())).iso3166Codes(in.getIso3166Codes());
        }

        @Override
        public ProviderMetadata build() {
            return new BaseProviderMetadata(this){};
        }
    }
}

