/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.providers;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.apis.ApiMetadata;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.providers.ProviderMetadata;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.providers.internal.BaseProviderMetadata;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.AnonymousHttpApiMetadata;

public class AnonymousProviderMetadata
extends BaseProviderMetadata {
    public static <A> ProviderMetadata forApiOnEndpoint(Class<A> api, String endpoint) {
        return AnonymousProviderMetadata.forApiWithEndpoint(AnonymousHttpApiMetadata.forApi(api), endpoint);
    }

    public static ProviderMetadata forApiWithEndpoint(ApiMetadata md, String endpoint) {
        Preconditions.checkNotNull(md, "api");
        Preconditions.checkNotNull(endpoint, "endpoint (%s)", (Object)md.getEndpointName());
        return new AnonymousProviderMetadata(md, endpoint);
    }

    @Override
    public Builder toBuilder() {
        return (Builder)new Builder(this.getApiMetadata(), this.getEndpoint()).fromProviderMetadata(this);
    }

    public AnonymousProviderMetadata(ApiMetadata apiMetadata, String endpoint) {
        super(new Builder(apiMetadata, endpoint));
    }

    public AnonymousProviderMetadata(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        public Builder(ApiMetadata apiMetadata, String endpoint) {
            this.id(Preconditions.checkNotNull(apiMetadata, "apiMetadata").getId()).name(apiMetadata.getName()).apiMetadata(apiMetadata).endpoint(endpoint);
        }

        @Override
        public AnonymousProviderMetadata build() {
            return new AnonymousProviderMetadata(this);
        }
    }
}

