/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.osgi;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ArrayListMultimap;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableSet;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Lists;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Multimap;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.apis.ApiMetadata;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.osgi.ApiListener;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.osgi.ApiRegistry;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.osgi.Bundles;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.osgi.ProviderListener;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.osgi.ProviderRegistry;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.providers.ProviderMetadata;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class MetadataBundleListener
implements BundleListener {
    private final Multimap<Long, ProviderMetadata> providerMetadataMap = ArrayListMultimap.create();
    private final Multimap<Long, ApiMetadata> apiMetadataMap = ArrayListMultimap.create();
    private final List<ProviderListener> providerListeners = Lists.newArrayList();
    private final List<ApiListener> apiListeners = Lists.newArrayList();

    public synchronized void start(BundleContext bundleContext) {
        bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : bundleContext.getBundles()) {
            if (bundle.getState() != 32) continue;
            this.addBundle(bundle);
        }
        bundleContext.addBundleListener((BundleListener)this);
    }

    public void stop(BundleContext bundleContext) {
        bundleContext.removeBundleListener((BundleListener)this);
        this.providerMetadataMap.clear();
        this.apiMetadataMap.clear();
        this.apiListeners.clear();
        this.providerListeners.clear();
    }

    public synchronized void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.addBundle(event.getBundle());
                break;
            }
            case 4: 
            case 256: {
                this.removeBundle(event.getBundle());
            }
        }
    }

    private synchronized void addBundle(Bundle bundle) {
        for (ProviderMetadata providerMetadata : this.listProviderMetadata(bundle)) {
            if (providerMetadata == null) continue;
            ProviderRegistry.registerProvider(providerMetadata);
            this.providerMetadataMap.put(bundle.getBundleId(), providerMetadata);
            for (ProviderListener providerListener : this.providerListeners) {
                providerListener.added(providerMetadata);
            }
        }
        for (ApiMetadata apiMetadata : this.listApiMetadata(bundle)) {
            if (apiMetadata == null) continue;
            ApiRegistry.registerApi(apiMetadata);
            this.apiMetadataMap.put(bundle.getBundleId(), apiMetadata);
            for (ApiListener apiListener : this.apiListeners) {
                apiListener.added(apiMetadata);
            }
        }
    }

    private synchronized void removeBundle(Bundle bundle) {
        for (ProviderMetadata providerMetadata : this.providerMetadataMap.removeAll(bundle.getBundleId())) {
            ProviderRegistry.unregisterProvider(providerMetadata);
            for (ProviderListener providerListener : this.providerListeners) {
                providerListener.removed(providerMetadata);
            }
        }
        for (ApiMetadata apiMetadata : this.apiMetadataMap.removeAll(bundle.getBundleId())) {
            ApiRegistry.unRegisterApi(apiMetadata);
            for (ApiListener apiListener : this.apiListeners) {
                apiListener.removed(apiMetadata);
            }
        }
    }

    public Iterable<ProviderMetadata> listProviderMetadata(Bundle bundle) {
        ImmutableSet<String> classNames = Bundles.stringsForResourceInBundle("/META-INF/services/org.jclouds.providers.ProviderMetadata", bundle);
        return Bundles.instantiateAvailableClasses(bundle, classNames, ProviderMetadata.class);
    }

    public Iterable<ApiMetadata> listApiMetadata(Bundle bundle) {
        ImmutableSet<String> classNames = Bundles.stringsForResourceInBundle("/META-INF/services/org.jclouds.apis.ApiMetadata", bundle);
        return Bundles.instantiateAvailableClasses(bundle, classNames, ApiMetadata.class);
    }

    public synchronized void addProviderListener(ProviderListener listener) {
        this.providerListeners.add(listener);
        for (ProviderMetadata metadata : this.providerMetadataMap.values()) {
            listener.added(metadata);
        }
    }

    public synchronized void removeProviderListener(ProviderListener listener) {
        this.providerListeners.remove(listener);
    }

    public synchronized void addApiListenerListener(ApiListener listener) {
        this.apiListeners.add(listener);
        for (ApiMetadata metadata : this.apiMetadataMap.values()) {
            listener.added(metadata);
        }
    }

    public synchronized void removeApiListenerListener(ApiListener listener) {
        this.apiListeners.remove(listener);
    }
}

