/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.config;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.VisibleForTesting;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicate;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Sets;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.ProvisionException;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.TypeLiteral;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.InjectionListener;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.TypeEncounter;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.TypeListener;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.Resource;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Named;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class BindLoggersAnnotatedWithResource
implements TypeListener {
    private final Logger.LoggerFactory loggerFactory;

    @Inject
    public BindLoggersAnnotatedWithResource(Logger.LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
    }

    @Override
    public <I> void hear(TypeLiteral<I> injectableType, TypeEncounter<I> encounter) {
        Class<I> type = injectableType.getRawType();
        Set<Field> loggerFields = this.getLoggerFieldsAnnotatedWithResource(type);
        if (loggerFields.isEmpty()) {
            return;
        }
        Logger logger = this.loggerFactory.getLogger(type.getName());
        for (Field field : loggerFields) {
            if (field.isAnnotationPresent(Named.class)) {
                Named name = field.getAnnotation(Named.class);
                encounter.register(new AssignLoggerToField(this.loggerFactory.getLogger(name.value()), field));
                continue;
            }
            encounter.register(new AssignLoggerToField(logger, field));
        }
    }

    @VisibleForTesting
    Set<Field> getLoggerFieldsAnnotatedWithResource(Class<?> declaredType) {
        HashSet<Field> fields = Sets.newHashSet();
        for (Class<?> type = declaredType; type != null; type = type.getSuperclass()) {
            fields.addAll(Arrays.asList(type.getDeclaredFields()));
        }
        return Sets.filter(fields, new LoggerFieldsAnnotatedWithResource());
    }

    static class LoggerFieldsAnnotatedWithResource
    implements Predicate<Field> {
        LoggerFieldsAnnotatedWithResource() {
        }

        @Override
        public boolean apply(Field from) {
            Resource inject = from.getAnnotation(Resource.class);
            return inject != null && from.getType().isAssignableFrom(Logger.class);
        }
    }

    static class AssignLoggerToField<I>
    implements InjectionListener<I> {
        private final Logger logger;
        private final Field field;

        AssignLoggerToField(Logger logger, Field field) {
            this.logger = logger;
            this.field = field;
        }

        @Override
        public void afterInjection(I injectee) {
            try {
                this.field.setAccessible(true);
                this.field.set(injectee, this.logger);
            }
            catch (IllegalAccessException e) {
                throw new ProvisionException(e.getMessage(), e);
            }
        }
    }
}

