/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.implicit;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicate;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicates;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Iterables;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.collect.Memoized;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.Location;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.LocationScope;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Region;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.functions.ToIdAndScope;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.predicates.LocationPredicates;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.ImplicitLocationSupplier;
import java.util.NoSuchElementException;
import java.util.Set;

@Singleton
public class OnlyLocationOrFirstRegionOptionallyMatchingRegionId
implements ImplicitLocationSupplier {
    private final Supplier<String> regionSupplier;
    private final Supplier<Set<? extends Location>> locationsSupplier;

    @Inject
    OnlyLocationOrFirstRegionOptionallyMatchingRegionId(@Region Supplier<String> regionSupplier, @Memoized Supplier<Set<? extends Location>> locationsSupplier) {
        this.regionSupplier = Preconditions.checkNotNull(regionSupplier, "regionSupplier");
        this.locationsSupplier = Preconditions.checkNotNull(locationsSupplier, "locationsSupplier");
    }

    @Override
    @Singleton
    public Location get() {
        String region = this.regionSupplier.get();
        Predicate<Location> locationPredicate = region == null ? Predicates.or(LocationPredicates.isZone(), LocationPredicates.isRegion()) : LocationPredicates.isZoneOrRegionWhereRegionIdEquals(region);
        Set<? extends Location> locations = this.locationsSupplier.get();
        if (this.locationsSupplier.get().size() == 1) {
            return (Location)Iterables.getOnlyElement((Iterable)this.locationsSupplier.get());
        }
        try {
            Location toReturn = Iterables.find(locations, locationPredicate);
            return toReturn.getScope() == LocationScope.REGION ? toReturn : toReturn.getParent();
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("couldn't find region matching %s in %s", locationPredicate, Iterables.transform(locations, ToIdAndScope.INSTANCE)));
        }
    }
}

