/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.implicit;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Iterables;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.collect.Memoized;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.Location;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.functions.ToIdAndScope;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.predicates.LocationPredicates;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.ImplicitLocationSupplier;
import java.util.NoSuchElementException;
import java.util.Set;

@Singleton
public class FirstNetwork
implements ImplicitLocationSupplier {
    private final Supplier<Set<? extends Location>> locationsSupplier;

    @Inject
    FirstNetwork(@Memoized Supplier<Set<? extends Location>> locationsSupplier) {
        this.locationsSupplier = Preconditions.checkNotNull(locationsSupplier, "locationsSupplierSupplier");
    }

    @Override
    public Location get() {
        Set<? extends Location> locations = this.locationsSupplier.get();
        try {
            return Iterables.find(locations, LocationPredicates.isNetwork());
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("none of the locations are scope NETWORK: " + Iterables.transform(locations, ToIdAndScope.INSTANCE));
        }
    }
}

