/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.all;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableSet;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Iterables;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.Location;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.LocationBuilder;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.LocationScope;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Iso3166;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Region;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.LocationsSupplier;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.all.JustProvider;
import java.util.Map;
import java.util.Set;

@Singleton
public class RegionToProvider
implements LocationsSupplier {
    private final JustProvider justProvider;
    private final Supplier<Set<String>> regionsSupplier;
    private final Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier;

    @Inject
    public RegionToProvider(JustProvider justProvider, @Region Supplier<Set<String>> regionsSupplier, @Iso3166 Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier) {
        this.justProvider = Preconditions.checkNotNull(justProvider, "justProvider");
        this.regionsSupplier = Preconditions.checkNotNull(regionsSupplier, "regionsSupplier");
        this.isoCodesByIdSupplier = Preconditions.checkNotNull(isoCodesByIdSupplier, "isoCodesByIdSupplier");
    }

    @Override
    public Set<? extends Location> get() {
        ImmutableSet.Builder locations = ImmutableSet.builder();
        Location provider = (Location)Iterables.getOnlyElement(this.justProvider.get());
        Set<String> regions = this.regionsSupplier.get();
        Preconditions.checkState(!regions.isEmpty(), "no regions found for provider %s, using supplier %s", (Object)provider, this.regionsSupplier);
        Map<String, Supplier<Set<String>>> isoCodesById = this.isoCodesByIdSupplier.get();
        for (String region : regions) {
            LocationBuilder builder = new LocationBuilder().scope(LocationScope.REGION).id(region).description(region).parent(provider);
            if (isoCodesById.containsKey(region)) {
                builder.iso3166Codes((Iterable<String>)isoCodesById.get(region).get());
            }
            locations.add(builder.build());
        }
        return locations.build();
    }
}

