/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.all;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableSet;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.Location;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.LocationBuilder;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.LocationScope;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Iso3166;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Provider;
import java.net.URI;
import java.util.Set;

@Singleton
public class JustProvider
implements Supplier<Set<? extends Location>> {
    private final String providerName;
    private final Supplier<URI> endpointSupplier;
    private final Set<String> isoCodesSupplier;

    @Inject
    public JustProvider(@Provider String providerName, @Provider Supplier<URI> endpointSupplier, @Iso3166 Set<String> isoCodesSupplier) {
        this.providerName = Preconditions.checkNotNull(providerName, "providerName");
        this.endpointSupplier = Preconditions.checkNotNull(endpointSupplier, "endpoint");
        this.isoCodesSupplier = Preconditions.checkNotNull(isoCodesSupplier, "isoCodes");
    }

    @Override
    public Set<? extends Location> get() {
        return ImmutableSet.of(new LocationBuilder().scope(LocationScope.PROVIDER).id(this.providerName).description(this.endpointSupplier.get().toASCIIString()).iso3166Codes(this.isoCodesSupplier).build());
    }
}

