/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.functions;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Zone;
import java.net.URI;
import java.util.Map;

public final class ZoneToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Supplier<URI>>> zoneToEndpoints;

    @Inject
    ZoneToEndpoint(@Zone Supplier<Map<String, Supplier<URI>>> zoneToEndpoints) {
        this.zoneToEndpoints = zoneToEndpoints;
    }

    @Override
    public URI apply(Object from) {
        Map<String, Supplier<URI>> zoneToEndpoint = this.zoneToEndpoints.get();
        Preconditions.checkState(!zoneToEndpoint.isEmpty(), "no zone name to endpoint mappings configured!");
        Preconditions.checkArgument(zoneToEndpoint.containsKey(from), "requested location %s, which is not a configured zone: %s", from, zoneToEndpoint);
        return zoneToEndpoint.get(from).get();
    }
}

