/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.json.internal;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.MoreObjects;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Objects;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.FluentIterable;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableCollection;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableList;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableMap;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableMultimap;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableSet;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Multimap;
import io.github.cdancy.jenkins.rest.shaded.com.google.gson.Gson;
import io.github.cdancy.jenkins.rest.shaded.com.google.gson.TypeAdapter;
import io.github.cdancy.jenkins.rest.shaded.com.google.gson.TypeAdapterFactory;
import io.github.cdancy.jenkins.rest.shaded.com.google.gson.internal.$Gson$Types;
import io.github.cdancy.jenkins.rest.shaded.com.google.gson.internal.JsonReaderInternalAccess;
import io.github.cdancy.jenkins.rest.shaded.com.google.gson.reflect.TypeToken;
import io.github.cdancy.jenkins.rest.shaded.com.google.gson.stream.JsonReader;
import io.github.cdancy.jenkins.rest.shaded.com.google.gson.stream.JsonToken;
import io.github.cdancy.jenkins.rest.shaded.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NullFilteringTypeAdapterFactories {
    private NullFilteringTypeAdapterFactories() {
    }

    static <T> TypeToken<?> resolve(TypeToken<T> ownerType, Type param) {
        return TypeToken.get($Gson$Types.resolve(ownerType.getType(), ownerType.getRawType(), param));
    }

    public static class MultimapTypeAdapterFactory
    extends MapTypeAdapterFactory {
        public MultimapTypeAdapterFactory() {
            super(Multimap.class);
        }

        @Override
        protected <K, V, T> TypeAdapter<T> newAdapter(TypeAdapter<K> keyAdapter, TypeAdapter<V> valueAdapter) {
            return new MultimapTypeAdapter<K, V>(keyAdapter, valueAdapter);
        }
    }

    private static final class MultimapTypeAdapter<K, V>
    extends TypeAdapter<Multimap<K, V>> {
        private final MapTypeAdapter<K, Iterable<V>> delegate;

        public MultimapTypeAdapter(TypeAdapter<K> keyAdapter, TypeAdapter<V> valueAdapter) {
            this.delegate = new MapTypeAdapter<K, V>(keyAdapter, new IterableTypeAdapter<V>(valueAdapter));
            this.nullSafe();
        }

        @Override
        public void write(JsonWriter out, Multimap<K, V> value) throws IOException {
            this.delegate.write(out, (Map)Map.class.cast(value.asMap()));
        }

        @Override
        public Multimap<K, V> read(JsonReader in) throws IOException {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (Map.Entry entry : this.delegate.read(in).entrySet()) {
                builder.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
            return builder.build();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MultimapTypeAdapter that = (MultimapTypeAdapter)MultimapTypeAdapter.class.cast(obj);
            return Objects.equal(this.delegate, that.delegate);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("keyAdapter", this.delegate.keyAdapter).add("valueAdapter", this.delegate.valueAdapter).toString();
        }
    }

    public static class MapTypeAdapterFactory
    implements TypeAdapterFactory {
        protected final Class<?> declaring;

        public MapTypeAdapterFactory() {
            this(Map.class);
        }

        protected MapTypeAdapterFactory(Class<?> declaring) {
            this.declaring = declaring;
        }

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> ownerType) {
            Type type = ownerType.getType();
            if (ownerType.getRawType() != this.declaring || !(type instanceof ParameterizedType)) {
                return null;
            }
            Type keyType = ((ParameterizedType)type).getActualTypeArguments()[0];
            Type valueType = ((ParameterizedType)type).getActualTypeArguments()[1];
            TypeAdapter<?> keyAdapter = gson.getAdapter(TypeToken.get(keyType));
            TypeAdapter<?> valueAdapter = gson.getAdapter(TypeToken.get(valueType));
            return this.newAdapter(keyAdapter, valueAdapter);
        }

        protected <K, V, T> TypeAdapter<T> newAdapter(TypeAdapter<K> keyAdapter, TypeAdapter<V> valueAdapter) {
            return new MapTypeAdapter<K, V>(keyAdapter, valueAdapter);
        }
    }

    public static class MapTypeAdapter<K, V>
    extends TypeAdapter<Map<K, V>> {
        protected final TypeAdapter<K> keyAdapter;
        protected final TypeAdapter<V> valueAdapter;

        protected MapTypeAdapter(TypeAdapter<K> keyAdapter, TypeAdapter<V> valueAdapter) {
            this.keyAdapter = keyAdapter;
            this.valueAdapter = valueAdapter;
            this.nullSafe();
        }

        @Override
        public void write(JsonWriter out, Map<K, V> value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            for (Map.Entry<K, V> element : value.entrySet()) {
                out.name(String.valueOf(element.getKey()));
                this.valueAdapter.write(out, element.getValue());
            }
            out.endObject();
        }

        @Override
        public Map<K, V> read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableMap.Builder<K, V> result = ImmutableMap.builder();
            in.beginObject();
            while (in.hasNext()) {
                JsonReaderInternalAccess.INSTANCE.promoteNameToValue(in);
                K name = this.keyAdapter.read(in);
                V value = this.valueAdapter.read(in);
                if (value == null) continue;
                result.put(name, value);
            }
            in.endObject();
            return result.build();
        }

        public int hashCode() {
            return Objects.hashCode(this.keyAdapter, this.valueAdapter);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MapTypeAdapter that = (MapTypeAdapter)MapTypeAdapter.class.cast(obj);
            return Objects.equal(this.keyAdapter, that.keyAdapter) && Objects.equal(this.valueAdapter, that.valueAdapter);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("keyAdapter", this.keyAdapter).add("valueAdapter", this.valueAdapter).toString();
        }
    }

    public static class ImmutableMapTypeAdapterFactory
    extends MapTypeAdapterFactory {
        public ImmutableMapTypeAdapterFactory() {
            super(ImmutableMap.class);
        }
    }

    public static class FluentIterableTypeAdapterFactory
    extends ImmutableListTypeAdapterFactory {
        public FluentIterableTypeAdapterFactory() {
            super(FluentIterable.class);
        }

        @Override
        protected <E, I> TypeAdapter<I> newAdapter(TypeAdapter<E> elementAdapter) {
            return new FluentIterableTypeAdapter<E>(elementAdapter);
        }
    }

    private static final class FluentIterableTypeAdapter<E>
    extends TypeAdapter<FluentIterable<E>> {
        private final IterableTypeAdapter<E> delegate;

        public FluentIterableTypeAdapter(TypeAdapter<E> elementAdapter) {
            this.delegate = new IterableTypeAdapter<E>(elementAdapter);
            this.nullSafe();
        }

        @Override
        public void write(JsonWriter out, FluentIterable<E> value) throws IOException {
            this.delegate.write(out, value.toList());
        }

        @Override
        public FluentIterable<E> read(JsonReader in) throws IOException {
            return FluentIterable.from(this.delegate.read(in));
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FluentIterableTypeAdapter that = (FluentIterableTypeAdapter)FluentIterableTypeAdapter.class.cast(obj);
            return Objects.equal(this.delegate, that.delegate);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("elementAdapter", ((IterableTypeAdapter)this.delegate).elementAdapter).toString();
        }
    }

    public static class SetTypeAdapterFactory
    extends ImmutableSetTypeAdapterFactory {
        public SetTypeAdapterFactory() {
            super(Set.class);
        }
    }

    public static class ImmutableSetTypeAdapterFactory
    extends ImmutableListTypeAdapterFactory {
        public ImmutableSetTypeAdapterFactory() {
            this(ImmutableSet.class);
        }

        protected ImmutableSetTypeAdapterFactory(Class<?> declaring) {
            super(declaring);
        }

        @Override
        protected <E, I> TypeAdapter<I> newAdapter(TypeAdapter<E> elementAdapter) {
            return new SetTypeAdapter<E>(elementAdapter);
        }
    }

    public static final class SetTypeAdapter<E>
    extends TypeAdapter<Set<E>> {
        private final IterableTypeAdapter<E> delegate;

        public SetTypeAdapter(TypeAdapter<E> elementAdapter) {
            this.delegate = new IterableTypeAdapter<E>(elementAdapter);
            this.nullSafe();
        }

        @Override
        public void write(JsonWriter out, Set<E> value) throws IOException {
            this.delegate.write(out, value);
        }

        @Override
        public Set<E> read(JsonReader in) throws IOException {
            return (Set)this.delegate.readAndBuild(in, ImmutableSet.builder());
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SetTypeAdapter that = (SetTypeAdapter)SetTypeAdapter.class.cast(obj);
            return Objects.equal(this.delegate, that.delegate);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("elementAdapter", ((IterableTypeAdapter)this.delegate).elementAdapter).toString();
        }
    }

    public static class ListTypeAdapterFactory
    extends ImmutableListTypeAdapterFactory {
        public ListTypeAdapterFactory() {
            super(List.class);
        }
    }

    public static class CollectionTypeAdapterFactory
    extends ImmutableListTypeAdapterFactory {
        public CollectionTypeAdapterFactory() {
            super(Collection.class);
        }
    }

    public static class IterableTypeAdapterFactory
    extends ImmutableListTypeAdapterFactory {
        public IterableTypeAdapterFactory() {
            super(Iterable.class);
        }
    }

    public static class ImmutableListTypeAdapterFactory
    implements TypeAdapterFactory {
        protected final Class<?> declaring;

        public ImmutableListTypeAdapterFactory() {
            this(ImmutableList.class);
        }

        protected ImmutableListTypeAdapterFactory(Class<?> declaring) {
            this.declaring = declaring;
        }

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> ownerType) {
            Type type = ownerType.getType();
            if (ownerType.getRawType() != this.declaring || !(type instanceof ParameterizedType)) {
                return null;
            }
            Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
            TypeAdapter<?> elementAdapter = gson.getAdapter(TypeToken.get(elementType));
            return this.newAdapter(elementAdapter);
        }

        protected <E, I> TypeAdapter<I> newAdapter(TypeAdapter<E> elementAdapter) {
            return new IterableTypeAdapter<E>(elementAdapter);
        }
    }

    public static final class IterableTypeAdapter<E>
    extends TypeAdapter<Iterable<E>> {
        private final TypeAdapter<E> elementAdapter;

        public IterableTypeAdapter(TypeAdapter<E> elementAdapter) {
            this.elementAdapter = elementAdapter;
            this.nullSafe();
        }

        @Override
        public void write(JsonWriter out, Iterable<E> value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (E element : value) {
                this.elementAdapter.write(out, element);
            }
            out.endArray();
        }

        @Override
        public Iterable<E> read(JsonReader in) throws IOException {
            return this.readAndBuild(in, ImmutableList.builder());
        }

        protected <C extends Iterable<E>, B extends ImmutableCollection.Builder<E>> C readAndBuild(JsonReader in, B builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            while (in.hasNext()) {
                E element = this.elementAdapter.read(in);
                if (element == null) continue;
                builder.add(element);
            }
            in.endArray();
            return (C)builder.build();
        }

        public int hashCode() {
            return this.elementAdapter.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IterableTypeAdapter that = (IterableTypeAdapter)IterableTypeAdapter.class.cast(obj);
            return Objects.equal(this.elementAdapter, that.elementAdapter);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("elementAdapter", this.elementAdapter).toString();
        }
    }
}

