/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.internal;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicate;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableMap;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Iterables;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Maps;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Binding;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Injector;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.TypeLiteral;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Named;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;

@Singleton
public class FilterStringsBoundToInjectorByName
implements Function<Predicate<String>, Map<String, String>> {
    private final Injector injector;

    @Inject
    public FilterStringsBoundToInjectorByName(Injector injector) {
        this.injector = Preconditions.checkNotNull(injector, "injector");
    }

    @Override
    public Map<String, String> apply(Predicate<String> filter) {
        List<Binding<String>> stringBindings = this.injector.findBindingsByType(TypeLiteral.get(String.class));
        Iterable<Binding<String>> annotatedWithName = Iterables.filter(stringBindings, new Predicate<Binding<String>>(){

            @Override
            public boolean apply(Binding<String> input) {
                Annotation annotation = input.getKey().getAnnotation();
                if (annotation == null) {
                    return false;
                }
                return annotation instanceof Named || annotation instanceof io.github.cdancy.jenkins.rest.shaded.com.google.inject.name.Named;
            }
        });
        ImmutableMap<String, Binding<String>> bindingsByName = Maps.uniqueIndex(annotatedWithName, new Function<Binding<String>, String>(){

            @Override
            public String apply(Binding<String> input) {
                Annotation annotation = input.getKey().getAnnotation();
                return annotation instanceof Named ? ((Named)Named.class.cast(annotation)).value() : ((io.github.cdancy.jenkins.rest.shaded.com.google.inject.name.Named)io.github.cdancy.jenkins.rest.shaded.com.google.inject.name.Named.class.cast(annotation)).value();
            }
        });
        Map<String, Binding<String>> filteredBindingsByName = Maps.filterKeys(bindingsByName, filter);
        Map<String, String> stringBoundByName = Maps.transformValues(filteredBindingsByName, new Function<Binding<String>, String>(){

            @Override
            public String apply(Binding<String> input) {
                return input.getProvider().get();
            }
        });
        return stringBoundByName;
    }
}

