/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.handlers;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.VisibleForTesting;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpCommand;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpErrorHandler;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponse;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.annotation.ClientError;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.annotation.Redirection;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.annotation.ServerError;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.handlers.CloseContentAndSetExceptionErrorHandler;

@Singleton
public class DelegatingErrorHandler
implements HttpErrorHandler {
    @Inject(optional=true)
    @Redirection
    @VisibleForTesting
    HttpErrorHandler redirectionHandler;
    @Inject(optional=true)
    @ClientError
    @VisibleForTesting
    HttpErrorHandler clientErrorHandler;
    @Inject(optional=true)
    @ServerError
    @VisibleForTesting
    HttpErrorHandler serverErrorHandler;

    @Inject
    DelegatingErrorHandler() {
        this.clientErrorHandler = this.redirectionHandler = new CloseContentAndSetExceptionErrorHandler();
        this.serverErrorHandler = this.redirectionHandler;
    }

    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        int statusCode = response.getStatusCode();
        if (statusCode >= 300 && statusCode < 400) {
            this.getRedirectionHandler().handleError(command, response);
        } else if (statusCode >= 400 && statusCode < 500) {
            this.getClientErrorHandler().handleError(command, response);
        } else if (statusCode >= 500) {
            this.getServerErrorHandler().handleError(command, response);
        }
    }

    public HttpErrorHandler getRedirectionHandler() {
        return this.redirectionHandler;
    }

    public HttpErrorHandler getClientErrorHandler() {
        return this.clientErrorHandler;
    }

    public HttpErrorHandler getServerErrorHandler() {
        return this.serverErrorHandler;
    }
}

