/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponse;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpUtils;

@Singleton
public class ParseETagHeader
implements Function<HttpResponse, String> {
    @Override
    public String apply(HttpResponse from) {
        HttpUtils.releasePayload(from);
        String eTag = from.getFirstHeaderOrNull("ETag");
        if (eTag == null) {
            eTag = from.getFirstHeaderOrNull("Etag");
        }
        if (eTag != null) {
            return eTag;
        }
        throw new HttpException("did not receive ETag");
    }
}

