/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.filters;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Charsets;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.io.BaseEncoding;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.Credentials;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequest;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequestFilter;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Provider;

@Singleton
public class BasicAuthentication
implements HttpRequestFilter {
    private final Supplier<Credentials> creds;

    @Inject
    public BasicAuthentication(@Provider Supplier<Credentials> creds) {
        this.creds = Preconditions.checkNotNull(creds, "creds");
    }

    public static String basic(String user, String password) {
        return "Basic " + BaseEncoding.base64().encode(String.format("%s:%s", Preconditions.checkNotNull(user, "user"), Preconditions.checkNotNull(password, "password")).getBytes(Charsets.UTF_8));
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        Credentials currentCreds = Preconditions.checkNotNull(this.creds.get(), "credential supplier returned null");
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("Authorization", BasicAuthentication.basic(currentCreds.identity, currentCreds.credential))).build();
    }
}

