/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.functions;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Optional;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicate;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableMap;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public class ExpandProperties
implements Function<Properties, Properties> {
    private static final Pattern VAR = Pattern.compile("\\$\\{[^\\}]+\\}");

    @Override
    public Properties apply(final Properties properties) {
        Map<String, String> leafs;
        Preconditions.checkNotNull(properties, "properties cannot be null");
        ImmutableMap<String, String> stringProperties = Maps.toMap(properties.stringPropertyNames(), new Function<String, String>(){

            @Override
            public String apply(String input) {
                return properties.getProperty(input);
            }
        });
        boolean pendingReplacements = true;
        HashMap<String, String> propertiesToResolve = new HashMap<String, String>(stringProperties);
        while (pendingReplacements && !(leafs = this.leafs(propertiesToResolve)).isEmpty()) {
            pendingReplacements = this.resolveProperties(propertiesToResolve, leafs);
        }
        Properties resolved = new Properties();
        resolved.putAll((Map<?, ?>)properties);
        for (Map.Entry entry : propertiesToResolve.entrySet()) {
            resolved.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return resolved;
    }

    private Map<String, String> leafs(Map<String, String> input) {
        return Maps.filterValues(input, new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                Matcher m3 = VAR.matcher(input);
                return !m3.find();
            }
        });
    }

    @SuppressModernizer
    private boolean resolveProperties(Map<String, String> properties, Map<String, String> variables) {
        boolean anyReplacementDone = false;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            StringBuffer sb = new StringBuffer();
            Matcher m3 = VAR.matcher(entry.getValue());
            while (m3.find()) {
                String match = m3.group();
                String var = match.substring(2, match.length() - 1);
                Optional<String> value = var.equals(key) ? Optional.absent() : Optional.fromNullable(variables.get(var));
                m3.appendReplacement(sb, value.or("\\" + match));
                if (!value.isPresent()) continue;
                anyReplacementDone = true;
            }
            m3.appendTail(sb);
            properties.put(key, sb.toString());
        }
        return anyReplacementDone;
    }
}

