/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.concurrent.config;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.util.concurrent.MoreExecutors;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.util.concurrent.SimpleTimeLimiter;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.util.concurrent.TimeLimiter;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.AbstractModule;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Provides;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.Resource;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Named;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.concurrent.DynamicExecutors;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.concurrent.config.ConfiguresExecutorService;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.concurrent.config.WithSubmissionTrace;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.lifecycle.Closer;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

@ConfiguresExecutorService
public class ExecutorServiceModule
extends AbstractModule {
    final ListeningExecutorService userExecutorFromConstructor;

    public ExecutorServiceModule() {
        this.userExecutorFromConstructor = null;
    }

    @Deprecated
    public ExecutorServiceModule(@Named(value="jclouds.user-threads") ExecutorService userExecutor, ExecutorService ioExecutor) {
        this(userExecutor);
    }

    @Deprecated
    public ExecutorServiceModule(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, ListeningExecutorService ioExecutor) {
        this(userExecutor);
    }

    public ExecutorServiceModule(@Named(value="jclouds.user-threads") ExecutorService userExecutor) {
        this(MoreExecutors.listeningDecorator(userExecutor));
    }

    public ExecutorServiceModule(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.userExecutorFromConstructor = WithSubmissionTrace.wrap(userExecutor);
    }

    @Override
    protected void configure() {
    }

    @Provides
    @Singleton
    final TimeLimiter timeLimiter(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        return SimpleTimeLimiter.create(userExecutor);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.user-threads")
    final ListeningExecutorService provideListeningUserExecutorService(@Named(value="jclouds.user-threads") int count, Closer closer) {
        if (this.userExecutorFromConstructor != null) {
            return this.userExecutorFromConstructor;
        }
        return ExecutorServiceModule.shutdownOnClose(WithSubmissionTrace.wrap(this.newThreadPoolNamed("user thread %d", count)), closer);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.user-threads")
    final ExecutorService provideUserExecutorService(@Named(value="jclouds.user-threads") ListeningExecutorService in) {
        return in;
    }

    static <T extends ListeningExecutorService> T shutdownOnClose(T service, Closer closer) {
        closer.addToClose(new ShutdownExecutorOnClose(service));
        return service;
    }

    private ListeningExecutorService newCachedThreadPoolNamed(String name) {
        return MoreExecutors.listeningDecorator(Executors.newCachedThreadPool(this.namedThreadFactory(name)));
    }

    private ListeningExecutorService newThreadPoolNamed(String name, int maxCount) {
        return maxCount == 0 ? this.newCachedThreadPoolNamed(name) : this.newScalingThreadPoolNamed(name, maxCount);
    }

    private ListeningExecutorService newScalingThreadPoolNamed(String name, int maxCount) {
        return MoreExecutors.listeningDecorator(DynamicExecutors.newScalingThreadPool(1, maxCount, 60000L, this.namedThreadFactory(name)));
    }

    private ThreadFactory namedThreadFactory(String name) {
        return new ThreadFactoryBuilder().setNameFormat(name).setThreadFactory(Executors.defaultThreadFactory()).build();
    }

    static final class ShutdownExecutorOnClose
    implements Closeable {
        @Resource
        private Logger logger = Logger.NULL;
        private final ListeningExecutorService service;

        private ShutdownExecutorOnClose(ListeningExecutorService service) {
            this.service = service;
        }

        @Override
        public void close() throws IOException {
            List<Runnable> runnables = this.service.shutdownNow();
            if (!runnables.isEmpty()) {
                this.logger.warn("when shutting down executor %s, runnables outstanding: %s", this.service, runnables);
            }
        }
    }
}

