/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.collect.internal;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.Beta;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.collect.IterableWithMarker;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.collect.PagedIterable;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.collect.PagedIterables;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequest;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.InvocationContext;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.internal.GeneratedHttpRequest;
import java.util.List;

@Beta
public abstract class ArgsToPagedIterable<T, I extends ArgsToPagedIterable<T, I>>
implements Function<IterableWithMarker<T>, PagedIterable<T>>,
InvocationContext<I> {
    protected GeneratedHttpRequest request;

    @Override
    public PagedIterable<T> apply(IterableWithMarker<T> input) {
        return input.nextMarker().isPresent() ? PagedIterables.advance(input, this.markerToNextForArgs(this.getArgs(this.request))) : PagedIterables.onlyPage(input);
    }

    protected List<Object> getArgs(GeneratedHttpRequest request) {
        return request.getInvocation().getArgs();
    }

    protected abstract Function<Object, IterableWithMarker<T>> markerToNextForArgs(List<Object> var1);

    @Override
    public I setContext(HttpRequest request) {
        Preconditions.checkArgument(request instanceof GeneratedHttpRequest, "ArgsToPagedIterable only supports a GeneratedHttpRequest");
        this.request = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request);
        return (I)this;
    }

    public static abstract class FromCaller<T, I extends FromCaller<T, I>>
    extends ArgsToPagedIterable<T, I> {
        @Override
        protected List<Object> getArgs(GeneratedHttpRequest request) {
            return request.getCaller().get().getArgs();
        }
    }
}

