/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.collect;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.collect.AbstractMapEntry;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TransformingMap<K, V1, V2>
extends AbstractMap<K, V2> {
    private final Map<K, V1> fromMap;
    private final Function<? super V1, V2> getFunction;
    private final Function<? super V2, V1> putFunction;

    public TransformingMap(Map<K, V1> fromMap, Function<? super V1, V2> getFunction, Function<? super V2, V1> putFunction) {
        this.fromMap = Preconditions.checkNotNull(fromMap);
        this.getFunction = Preconditions.checkNotNull(getFunction);
        this.putFunction = Preconditions.checkNotNull(putFunction);
    }

    @Override
    public int size() {
        return this.fromMap.size();
    }

    @Override
    public V2 put(K key, V2 value) {
        V2 old = this.get(key);
        this.fromMap.put(key, value != null ? (Object)this.putFunction.apply((V2)value) : null);
        return old;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.fromMap.containsKey(key);
    }

    @Override
    public V2 get(Object key) {
        V1 value = this.fromMap.get(key);
        return (V2)(value != null || this.fromMap.containsKey(key) ? this.getFunction.apply(value) : null);
    }

    @Override
    public V2 remove(Object key) {
        return this.fromMap.containsKey(key) ? (V2)this.getFunction.apply((V1)this.fromMap.remove(key)) : null;
    }

    @Override
    public void clear() {
        this.fromMap.clear();
    }

    @Override
    public Set<Map.Entry<K, V2>> entrySet() {
        return new EntrySet();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V2>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return TransformingMap.this.size();
        }

        @Override
        public Iterator<Map.Entry<K, V2>> iterator() {
            final Iterator mapIterator = TransformingMap.this.fromMap.entrySet().iterator();
            return new Iterator<Map.Entry<K, V2>>(){

                @Override
                public boolean hasNext() {
                    return mapIterator.hasNext();
                }

                @Override
                public Map.Entry<K, V2> next() {
                    final Map.Entry entry = (Map.Entry)mapIterator.next();
                    return new AbstractMapEntry<K, V2>(){

                        @Override
                        public K getKey() {
                            return entry.getKey();
                        }

                        @Override
                        public V2 getValue() {
                            return TransformingMap.this.getFunction.apply(entry.getValue());
                        }
                    };
                }

                @Override
                public void remove() {
                    mapIterator.remove();
                }
            };
        }

        @Override
        public void clear() {
            TransformingMap.this.fromMap.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            Object mapValue = TransformingMap.this.get(entryKey);
            if (mapValue != null) {
                return mapValue.equals(entryValue);
            }
            return entryValue == null && TransformingMap.this.containsKey(entryKey);
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                TransformingMap.this.fromMap.remove(key);
                return true;
            }
            return false;
        }
    }
}

