/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.apis;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicate;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicates;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Strings;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.reflect.TypeToken;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.View;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.apis.ApiMetadata;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.TypeTokenUtils;

public class ApiPredicates {
    public static Predicate<ApiMetadata> all() {
        return Predicates.alwaysTrue();
    }

    public static Predicate<ApiMetadata> id(final String id) {
        Preconditions.checkNotNull(Strings.emptyToNull(id), "id must be defined");
        return new Predicate<ApiMetadata>(){

            @Override
            public boolean apply(ApiMetadata apiMetadata) {
                return apiMetadata.getId().equals(id);
            }

            public String toString() {
                return "id(" + id + ")";
            }
        };
    }

    public static Predicate<ApiMetadata> contextAssignableFrom(final TypeToken<?> type) {
        Preconditions.checkNotNull(type, "context must be defined");
        return new Predicate<ApiMetadata>(){

            @Override
            public boolean apply(ApiMetadata apiMetadata) {
                return TypeTokenUtils.isSupertypeOf(type, apiMetadata.getContext());
            }

            public String toString() {
                return "contextAssignableFrom(" + type + ")";
            }
        };
    }

    public static Predicate<ApiMetadata> viewableAs(final TypeToken<?> type) {
        Preconditions.checkNotNull(type, "context must be defined");
        return new Predicate<ApiMetadata>(){

            @Override
            public boolean apply(ApiMetadata apiMetadata) {
                for (TypeToken<? extends View> to : apiMetadata.getViews()) {
                    if (!TypeTokenUtils.isSupertypeOf(type, to)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "viewableAs(" + type + ")";
            }
        };
    }
}

