/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.com.google.inject.util;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Objects;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableSet;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Sets;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Injector;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Provider;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.Dependency;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.InjectionPoint;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.ProviderWithDependencies;
import java.util.HashSet;
import java.util.Set;

public final class Providers {
    private Providers() {
    }

    public static <T> Provider<T> of(T instance) {
        return new ConstantProvider(instance);
    }

    public static <T> Provider<T> guicify(io.github.cdancy.jenkins.rest.shaded.javax.inject.Provider<T> provider) {
        if (provider instanceof Provider) {
            return (Provider)provider;
        }
        io.github.cdancy.jenkins.rest.shaded.javax.inject.Provider<T> delegate = Preconditions.checkNotNull(provider, "provider");
        Set<InjectionPoint> injectionPoints = InjectionPoint.forInstanceMethodsAndFields(provider.getClass());
        if (injectionPoints.isEmpty()) {
            return new GuicifiedProvider(delegate);
        }
        HashSet<Dependency<?>> mutableDeps = Sets.newHashSet();
        for (InjectionPoint ip : injectionPoints) {
            mutableDeps.addAll(ip.getDependencies());
        }
        ImmutableSet dependencies = ImmutableSet.copyOf(mutableDeps);
        return new GuicifiedProviderWithDependencies(dependencies, delegate);
    }

    private static final class GuicifiedProviderWithDependencies<T>
    extends GuicifiedProvider<T>
    implements ProviderWithDependencies<T> {
        private final Set<Dependency<?>> dependencies;

        private GuicifiedProviderWithDependencies(Set<Dependency<?>> dependencies, io.github.cdancy.jenkins.rest.shaded.javax.inject.Provider<T> delegate) {
            super(delegate);
            this.dependencies = dependencies;
        }

        @Inject
        void initialize(Injector injector) {
            injector.injectMembers(this.delegate);
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.dependencies;
        }
    }

    private static class GuicifiedProvider<T>
    implements Provider<T> {
        protected final io.github.cdancy.jenkins.rest.shaded.javax.inject.Provider<T> delegate;

        private GuicifiedProvider(io.github.cdancy.jenkins.rest.shaded.javax.inject.Provider<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T get() {
            return this.delegate.get();
        }

        public String toString() {
            return "guicified(" + this.delegate + ")";
        }

        public boolean equals(Object obj) {
            return obj instanceof GuicifiedProvider && Objects.equal(this.delegate, ((GuicifiedProvider)obj).delegate);
        }

        public int hashCode() {
            return Objects.hashCode(this.delegate);
        }
    }

    private static final class ConstantProvider<T>
    implements Provider<T> {
        private final T instance;

        private ConstantProvider(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public String toString() {
            return "of(" + this.instance + ")";
        }

        public boolean equals(Object obj) {
            return obj instanceof ConstantProvider && Objects.equal(this.instance, ((ConstantProvider)obj).instance);
        }

        public int hashCode() {
            return Objects.hashCode(this.instance);
        }
    }
}

