/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableSet;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.ConstructionContext;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.ConstructionProxy;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.InternalContext;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.InternalProvisionException;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.MembersInjectorImpl;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.ProvisionListenerStackCallback;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.SingleParameterInjector;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.Dependency;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.InjectionPoint;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;

final class ConstructorInjector<T> {
    private final ImmutableSet<InjectionPoint> injectableMembers;
    private final SingleParameterInjector<?>[] parameterInjectors;
    private final ConstructionProxy<T> constructionProxy;
    private final MembersInjectorImpl<T> membersInjector;

    ConstructorInjector(Set<InjectionPoint> injectableMembers, ConstructionProxy<T> constructionProxy, SingleParameterInjector<?>[] parameterInjectors, MembersInjectorImpl<T> membersInjector) {
        this.injectableMembers = ImmutableSet.copyOf(injectableMembers);
        this.constructionProxy = constructionProxy;
        this.parameterInjectors = parameterInjectors;
        this.membersInjector = membersInjector;
    }

    public ImmutableSet<InjectionPoint> getInjectableMembers() {
        return this.injectableMembers;
    }

    ConstructionProxy<T> getConstructionProxy() {
        return this.constructionProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object construct(final InternalContext context, Dependency<?> dependency, @Nullable ProvisionListenerStackCallback<T> provisionCallback) throws InternalProvisionException {
        final ConstructionContext constructionContext = context.getConstructionContext(this);
        if (constructionContext.isConstructing()) {
            return constructionContext.createProxy(context.getInjectorOptions(), dependency.getKey().getTypeLiteral().getRawType());
        }
        Object t = constructionContext.getCurrentReference();
        if (t != null) {
            if (context.getInjectorOptions().disableCircularProxies) {
                throw InternalProvisionException.circularDependenciesDisabled(dependency.getKey().getTypeLiteral().getRawType());
            }
            return t;
        }
        constructionContext.startConstruction();
        try {
            if (provisionCallback == null) {
                Object t2 = this.provision(context, constructionContext);
                return t2;
            }
            T t3 = provisionCallback.provision(context, new ProvisionListenerStackCallback.ProvisionCallback<T>(){

                @Override
                public T call() throws InternalProvisionException {
                    return ConstructorInjector.this.provision(context, constructionContext);
                }
            });
            return t3;
        }
        finally {
            constructionContext.finishConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T provision(InternalContext context, ConstructionContext<T> constructionContext) throws InternalProvisionException {
        try {
            T t;
            try {
                Object[] parameters = SingleParameterInjector.getAll(context, this.parameterInjectors);
                t = this.constructionProxy.newInstance(parameters);
                constructionContext.setProxyDelegates(t);
            }
            finally {
                constructionContext.finishConstruction();
            }
            constructionContext.setCurrentReference(t);
            MembersInjectorImpl<T> localMembersInjector = this.membersInjector;
            localMembersInjector.injectMembers(t, context, false);
            localMembersInjector.notifyListeners(t);
            T t2 = t;
            return t2;
        }
        catch (InvocationTargetException userException) {
            Throwable cause = userException.getCause() != null ? userException.getCause() : userException;
            throw InternalProvisionException.errorInjectingConstructor(cause).addSource(this.constructionProxy.getInjectionPoint());
        }
        finally {
            constructionContext.removeCurrentReference();
        }
    }
}

