/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.filters;

import com.cdancy.jenkins.rest.JenkinsAuthentication;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequest;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequestFilter;

@Singleton
public class JenkinsUserInjectionFilter
implements HttpRequestFilter {
    private static final String USER_PLACE_HOLDER = "%7Buser%7D";
    private final JenkinsAuthentication creds;

    @Inject
    public JenkinsUserInjectionFilter(JenkinsAuthentication creds) {
        this.creds = creds;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        String requestPath = request.getEndpoint().getRawPath().replaceAll(USER_PLACE_HOLDER, this.creds.identity);
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).fromHttpRequest(request)).replacePath(requestPath)).build();
    }
}

