/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.features;

import com.cdancy.jenkins.rest.domain.common.RequestStatus;
import com.cdancy.jenkins.rest.domain.plugins.Plugins;
import com.cdancy.jenkins.rest.fallbacks.JenkinsFallbacks;
import com.cdancy.jenkins.rest.filters.JenkinsAuthenticationFilter;
import com.cdancy.jenkins.rest.parsers.RequestStatusParser;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={JenkinsAuthenticationFilter.class})
@Consumes(value={"application/json"})
@Path(value="/pluginManager")
public interface PluginManagerApi {
    @Named(value="pluginManager:plugins")
    @Path(value="/api/json")
    @Fallback(value=JenkinsFallbacks.PluginsOnError.class)
    @GET
    public Plugins plugins(@Nullable @QueryParam(value="depth") Integer var1, @Nullable @QueryParam(value="tree") String var2);

    @Named(value="pluginManager:install-necessary-plugins")
    @Path(value="/installNecessaryPlugins")
    @Fallback(value=JenkinsFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @Produces(value={"application/xml"})
    @Payload(value="<jenkins><install plugin=\"{pluginID}\"/></jenkins>")
    @POST
    public RequestStatus installNecessaryPlugins(@PayloadParam(value="pluginID") String var1);
}

