/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.parsers;

import com.cdancy.jenkins.rest.domain.job.ProgressiveText;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.io.CharStreams;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;

@Singleton
public class OutputToProgressiveText
implements Function<HttpResponse, ProgressiveText> {
    public ProgressiveText apply(HttpResponse response) {
        String text = this.getTextOutput(response);
        int size = this.getTextSize(response);
        boolean hasMoreData = this.getMoreData(response);
        return ProgressiveText.create(text, size, hasMoreData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTextOutput(HttpResponse response) {
        InputStream is = null;
        try {
            is = response.getPayload().openStream();
            String string = CharStreams.toString((Readable)new InputStreamReader(is, Charsets.UTF_8));
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public int getTextSize(HttpResponse response) {
        String textSize = response.getFirstHeaderOrNull("X-Text-Size");
        return textSize != null ? Integer.valueOf(textSize) : -1;
    }

    public boolean getMoreData(HttpResponse response) {
        String moreData = response.getFirstHeaderOrNull("X-More-Data");
        return moreData != null ? Boolean.valueOf(moreData) : false;
    }
}

