/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.domain.queue;

import com.cdancy.jenkins.rest.domain.queue.AutoValue_QueueItem;
import com.cdancy.jenkins.rest.domain.queue.Executable;
import com.cdancy.jenkins.rest.domain.queue.Task;
import com.google.auto.value.AutoValue;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class QueueItem {
    public abstract boolean blocked();

    public abstract boolean buildable();

    public abstract int id();

    public abstract long inQueueSince();

    public abstract Map<String, String> params();

    public abstract boolean stuck();

    public abstract Task task();

    public abstract String url();

    @Nullable
    public abstract String why();

    public abstract long buildableStartMilliseconds();

    public abstract boolean cancelled();

    @Nullable
    public abstract Executable executable();

    @Nullable
    public abstract Long timestamp();

    QueueItem() {
    }

    @SerializedNames(value={"blocked", "buildable", "id", "inQueueSince", "params", "stuck", "task", "url", "why", "buildableStartMilliseconds", "cancelled", "executable", "timestamp"})
    public static QueueItem create(boolean blocked, boolean buildable, int id, long inQueueSince, String params, boolean stuck, Task task, String url, String why, long buildableStartMilliseconds, boolean cancelled, Executable executable, Long timestamp) {
        HashMap parameters = Maps.newHashMap();
        if (params != null && (params = params.trim()).length() > 0) {
            for (String keyValue : params.split("\n")) {
                String[] pair = keyValue.split("=");
                parameters.put(pair[0], pair.length > 1 ? pair[1] : "");
            }
        }
        return new AutoValue_QueueItem(blocked, buildable, id, inQueueSince, parameters, stuck, task, url, why, buildableStartMilliseconds, cancelled, executable, timestamp);
    }
}

