/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import io.github.bric3.fireplace.flamegraph.FrameBox;
import io.github.bric3.fireplace.flamegraph.FrameColorProvider;
import io.github.bric3.fireplace.flamegraph.FrameFontProvider;
import io.github.bric3.fireplace.flamegraph.FrameModel;
import io.github.bric3.fireplace.flamegraph.FrameRenderingFlags;
import io.github.bric3.fireplace.flamegraph.FrameTextsProvider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

class FrameRenderer<T> {
    @NotNull
    private @NotNull FrameTextsProvider<@NotNull T> frameTextsProvider;
    @NotNull
    private @NotNull FrameFontProvider<@NotNull T> frameFontProvider;
    @NotNull
    private @NotNull FrameColorProvider<@NotNull T> frameColorProvider;
    private final int frameTextPadding = 2;
    private boolean drawingFrameGap = true;
    private final int frameGapWidth = 1;
    public final int frameBorderWidth = 1;
    @NotNull
    public Stroke frameBorderStroke = new BasicStroke(1.0f);

    public FrameRenderer(@NotNull @NotNull FrameTextsProvider<@NotNull T> frameTextsProvider, @NotNull @NotNull FrameColorProvider<@NotNull T> frameColorProvider, @NotNull @NotNull FrameFontProvider<@NotNull T> frameFontProvider) {
        this.frameTextsProvider = Objects.requireNonNull(frameTextsProvider, "nodeToTextProvider");
        this.frameColorProvider = Objects.requireNonNull(frameColorProvider, "frameColorProvider");
        this.frameFontProvider = Objects.requireNonNull(frameFontProvider, "frameFontProvider");
    }

    public int getFrameTextPadding() {
        return 2;
    }

    public int getFrameGapWidth() {
        return 1;
    }

    public void setDrawingFrameGap(boolean drawingFrameGap) {
        this.drawingFrameGap = drawingFrameGap;
    }

    public boolean isDrawingFrameGap() {
        return this.drawingFrameGap;
    }

    public int getFrameBoxHeight(@NotNull Graphics2D g2) {
        return g2.getFontMetrics(this.frameFontProvider.getFont(null, 0)).getAscent() + 4 + 2;
    }

    public float getFrameBoxTextOffset(@NotNull Graphics2D g2) {
        return (float)this.getFrameBoxHeight(g2) - (float)g2.getFontMetrics(this.frameFontProvider.getFont(null, 0)).getDescent() / 2.0f - 2.0f - 1.0f;
    }

    void paintFrame(@NotNull Graphics2D g2, @NotNull @NotNull FrameModel<@NotNull T> frameModel, @NotNull Rectangle2D frameRect, @NotNull @NotNull FrameBox<@NotNull T> frame, @NotNull Rectangle2D paintableIntersection, int flags) {
        boolean minimapMode = FrameRenderingFlags.isMinimapMode(flags);
        FrameColorProvider.ColorModel colorModel = this.frameColorProvider.getColors(frame, flags);
        this.paintFrameRectangle(g2, frameRect, Objects.requireNonNull(colorModel.background, "colorModel.background is nullable; however, at when rendering it is not anymore allowed"), minimapMode);
        if (minimapMode) {
            return;
        }
        Font frameFont = this.frameFontProvider.getFont(frame, flags);
        String text = this.calculateFrameText(g2, frameFont, paintableIntersection.getWidth() - 4.0 - 2.0, frameModel, frame);
        if (text == null || text.isEmpty()) {
            return;
        }
        g2.setFont(frameFont);
        g2.setColor(Objects.requireNonNull(colorModel.foreground, "colorModel.background is nullable; however, at when rendering it is not anymore allowed"));
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.drawString(text, (float)(paintableIntersection.getX() + 2.0 + 1.0), (float)(frameRect.getY() + (double)this.getFrameBoxTextOffset(g2)));
    }

    private void paintFrameRectangle(@NotNull Graphics2D g2, @NotNull Rectangle2D frameRect, @NotNull Color bgColor, boolean minimapMode) {
        boolean gapThickness = minimapMode ? false : this.drawingFrameGap;
        double x = frameRect.getX();
        double y = frameRect.getY();
        double w = frameRect.getWidth() - (double)gapThickness;
        double h = frameRect.getHeight() - (double)gapThickness;
        frameRect.setRect(x, y, w, h);
        g2.setColor(bgColor);
        g2.fill(frameRect);
    }

    private String calculateFrameText(@NotNull Graphics2D g2, @NotNull Font font, double targetWidth, @NotNull @NotNull FrameModel<@NotNull T> frameModel, @NotNull @NotNull FrameBox<@NotNull T> frame) {
        Object textBounds;
        String textCandidate;
        FontMetrics metrics = g2.getFontMetrics(font);
        String string = textCandidate = frame.isRoot() ? frameModel.title : "";
        if (frame.isRoot() && !textCandidate.isBlank()) {
            textBounds = metrics.getStringBounds(textCandidate, g2);
            if (((RectangularShape)textBounds).getWidth() <= targetWidth) {
                return textCandidate;
            }
        } else {
            textBounds = this.frameTextsProvider.frameToTextCandidates().iterator();
            while (textBounds.hasNext()) {
                Function nodeToTextCandidate = (Function)textBounds.next();
                textCandidate = Objects.requireNonNullElse((String)nodeToTextCandidate.apply(frame), "");
                Rectangle2D textBounds2 = metrics.getStringBounds(textCandidate, g2);
                if (!(textBounds2.getWidth() <= targetWidth)) continue;
                return textCandidate;
            }
        }
        if (((RectangularShape)(textBounds = metrics.getStringBounds(textCandidate = this.frameTextsProvider.clipStrategy().clipString(font, metrics, targetWidth, textCandidate, "\u2026"), g2))).getWidth() > targetWidth || textCandidate.length() <= "\u2026".length() + 1) {
            return null;
        }
        return textCandidate;
    }

    public void setFrameTextsProvider(@NotNull @NotNull FrameTextsProvider<@NotNull T> frameTextsProvider) {
        this.frameTextsProvider = Objects.requireNonNull(frameTextsProvider, "frameTextsProvider");
    }

    @NotNull
    public @NotNull FrameTextsProvider<@NotNull T> getFrameTextsProvider() {
        return this.frameTextsProvider;
    }

    public void setFrameFontProvider(@NotNull @NotNull FrameFontProvider<@NotNull T> frameFontProvider) {
        this.frameFontProvider = Objects.requireNonNull(frameFontProvider, "frameFontProvider");
    }

    @NotNull
    public @NotNull FrameFontProvider<@NotNull T> getFrameFontProvider() {
        return this.frameFontProvider;
    }

    public void setFrameColorProvider(@NotNull @NotNull FrameColorProvider<@NotNull T> frameColorProvider) {
        this.frameColorProvider = Objects.requireNonNull(frameColorProvider, "frameColorProvider");
    }

    @NotNull
    public @NotNull FrameColorProvider<@NotNull T> getFrameColorProvider() {
        return this.frameColorProvider;
    }
}

