/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shell {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private Shell() {
        throw new IllegalStateException("Utility class");
    }

    public static String runAndWait(String ... command) {
        return Shell.runAndWaitArray(new File("."), command);
    }

    public static String runAndWait(File folder, String ... command) {
        return Shell.runAndWaitArray(folder, command);
    }

    public static String runAndWaitArray(File folder, String[] command) {
        String commandStr = Arrays.toString(command);
        log.debug("Running command on the shell: {}", (Object)commandStr);
        String result = Shell.runAndWaitNoLog(folder, command);
        log.debug("Result: {}", (Object)result);
        return result;
    }

    public static String runAndWaitNoLog(File folder, String ... command) {
        String output;
        block2: {
            output = "";
            try {
                Process process = new ProcessBuilder(command).directory(folder).redirectErrorStream(false).start();
                output = IOUtils.toString((InputStream)process.getInputStream(), (Charset)StandardCharsets.UTF_8);
                process.destroy();
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("There was a problem executing command <{}> on the shell: {}", (Object)String.join((CharSequence)" ", command), (Object)e.getMessage());
            }
        }
        return output.trim();
    }

    public static String getVersionFromWmicOutput(String output) {
        int i = output.indexOf(61);
        int j = output.indexOf(46);
        return i != -1 && j != -1 ? output.substring(i + 1, j) : output;
    }

    public static String getVersionFromPosixOutput(String output, String driverType) {
        if (output.contains("Chromium")) {
            driverType = "Chromium";
        }
        int i = output.indexOf(driverType);
        int j = output.indexOf(46);
        return i != -1 && j != -1 ? output.substring(i + driverType.length(), j).trim() : output;
    }

    public static String getVersionFromPowerShellOutput(String output) {
        int i = output.indexOf("Version");
        int j = output.indexOf(58, i);
        int k = output.indexOf(46, j);
        return i != -1 && j != -1 && k != -1 ? output.substring(j + 1, k).trim() : output;
    }
}

