/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.ChromeDriverManager;
import io.github.bonigarcia.wdm.DriverManagerType;
import java.io.File;
import java.util.Optional;

public class ChromiumDriverManager
extends ChromeDriverManager {
    @Override
    protected DriverManagerType getDriverManagerType() {
        return DriverManagerType.CHROMIUM;
    }

    @Override
    protected Optional<String> getBrowserVersion() {
        String[] programFilesEnvs = new String[]{"LOCALAPPDATA", this.getProgramFilesEnv(), this.getOtherProgramFilesEnv()};
        return this.getDefaultBrowserVersion(programFilesEnvs, "\\\\Chromium\\\\Application\\\\chrome.exe", "chromium-browser", "/Applications/Chromium.app/Contents/MacOS/Chromium", "--version", this.getDriverManagerType().toString());
    }

    protected boolean snapDriverExists() {
        String chromiumDriverSnapPath = this.config().getChromiumDriverSnapPath();
        File snapChromiumDriverPath = new File(chromiumDriverSnapPath);
        boolean existsSnap = snapChromiumDriverPath.exists();
        if (existsSnap) {
            log.debug("Found {} snap", (Object)this.getDriverManagerType());
            this.exportDriver(chromiumDriverSnapPath);
        }
        return existsSnap;
    }
}

