/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.fs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTemporaryLocationProvider {
    private static final String FRAG = "protobuf-maven-plugin";
    private static final Logger log = LoggerFactory.getLogger(AbstractTemporaryLocationProvider.class);
    private final MojoExecution mojoExecution;

    protected AbstractTemporaryLocationProvider(MojoExecution mojoExecution) {
        this.mojoExecution = mojoExecution;
    }

    protected Path resolveAndCreateDirectory(Path basePath, String ... bits) throws IOException {
        String goal = Objects.requireNonNullElse(this.mojoExecution.getGoal(), "unknown-goal");
        String executionId = Objects.requireNonNullElse(this.mojoExecution.getExecutionId(), "unknown-execution-id");
        Path dir = basePath.resolve(FRAG).resolve(goal).resolve(executionId);
        for (String bit : bits) {
            dir = dir.resolve(bit);
        }
        log.trace("Creating temporary location at \"{}\" if it does not already exist...", (Object)dir);
        return Files.createDirectories(dir, new FileAttribute[0]);
    }
}

