/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies.aether;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherArtifactMapper;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherDependencyManagement;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherResolver;
import io.github.ascopes.protobufmavenplugin.digests.Digest;
import io.github.ascopes.protobufmavenplugin.fs.FileUtils;
import io.github.ascopes.protobufmavenplugin.fs.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Integrates with Eclipse Aether to resolve and download dependencies locally")
@MojoExecutionScoped
@Named
final class AetherMavenArtifactPathResolver
implements MavenArtifactPathResolver {
    private static final Logger log = LoggerFactory.getLogger(AetherMavenArtifactPathResolver.class);
    private final MavenSession mavenSession;
    private final AetherArtifactMapper aetherArtifactMapper;
    private final AetherDependencyManagement aetherDependencyManagement;
    private final AetherResolver aetherResolver;
    private final TemporarySpace temporarySpace;

    @Inject
    AetherMavenArtifactPathResolver(MavenSession mavenSession, AetherArtifactMapper aetherArtifactMapper, AetherDependencyManagement aetherDependencyManagement, AetherResolver aetherResolver, TemporarySpace temporarySpace) {
        this.mavenSession = mavenSession;
        this.aetherArtifactMapper = aetherArtifactMapper;
        this.aetherDependencyManagement = aetherDependencyManagement;
        this.aetherResolver = aetherResolver;
        this.temporarySpace = temporarySpace;
    }

    @Override
    public Path resolveExecutable(MavenArtifact artifact) throws ResolutionException {
        log.debug("Resolving artifact \"{}\"", (Object)artifact);
        Artifact unresolvedArtifact = this.aetherArtifactMapper.mapPmpArtifactToEclipseArtifact(artifact);
        Artifact resolvedArtifact = this.aetherResolver.resolveRequiredArtifact(unresolvedArtifact);
        Path originalPath = this.aetherArtifactMapper.mapEclipseArtifactToPath(resolvedArtifact);
        String digestPart = Digest.compute("SHA-1", artifact.toString()).toHexString();
        Path finalPath = this.temporarySpace.createTemporarySpace("artifacts").resolve(artifact.getArtifactId() + "-" + digestPart + ".exe");
        try {
            log.debug("Copying \"{}\" to \"{}\" and making executable", (Object)originalPath, (Object)finalPath);
            Files.copy(originalPath, finalPath, StandardCopyOption.REPLACE_EXISTING);
            FileUtils.makeExecutable(finalPath);
        }
        catch (IOException ex) {
            throw new ResolutionException("Failed to process downloaded artifact " + String.valueOf(artifact), ex);
        }
        return finalPath;
    }

    @Override
    public List<Path> resolveDependencies(Collection<? extends MavenArtifact> artifacts, DependencyResolutionDepth depth, Set<String> dependencyScopes, boolean includeProjectArtifacts) throws ResolutionException {
        ArrayList<Dependency> unresolvedDependencies = new ArrayList<Dependency>();
        artifacts.stream().peek(artifact -> log.debug("Resolving artifact \"{}\" as dependency", artifact)).map(artifact -> this.aetherArtifactMapper.mapPmpArtifactToEclipseDependency((MavenArtifact)artifact, depth)).map(this.aetherDependencyManagement::fillManagedAttributes).forEach(unresolvedDependencies::add);
        Stream<Artifact> resolvedArtifacts = this.aetherResolver.resolveDependencies(unresolvedDependencies, dependencyScopes).stream();
        if (includeProjectArtifacts) {
            log.debug("Querying project dependencies from Maven model, as requested.");
            Stream<Artifact> projectArtifacts = this.mavenSession.getCurrentProject().getArtifacts().stream().filter(artifact -> dependencyScopes.contains(artifact.getScope())).peek(artifact -> log.trace("Including project artifact \"{}\"", artifact)).map(this.aetherArtifactMapper::mapMavenArtifactToEclipseArtifact);
            resolvedArtifacts = Stream.concat(projectArtifacts, resolvedArtifacts);
        }
        return resolvedArtifacts.collect(AetherDependencyManagement.deduplicateArtifacts()).values().stream().map(this.aetherArtifactMapper::mapEclipseArtifactToPath).toList();
    }
}

