/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.urls;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

abstract class AbstractNestingUrlConnection
extends URLConnection {
    private final URL nestedUrl;
    private @Nullable URLConnection nestedConnection;
    private @Nullable InputStream nestedInputStream;

    AbstractNestingUrlConnection(URL url, URL nestedUrl) {
        super(url);
        this.nestedUrl = Objects.requireNonNull(nestedUrl);
        this.setDoOutput(false);
    }

    public URL getNestedUrl() {
        return this.nestedUrl;
    }

    @Override
    public final void connect() throws NestedUrlException {
        if (this.connected) {
            return;
        }
        try {
            URLConnection nestedConnection = this.nestedUrl.openConnection();
            nestedConnection.setAllowUserInteraction(this.getAllowUserInteraction());
            nestedConnection.setConnectTimeout(this.getConnectTimeout());
            nestedConnection.setDoInput(this.getDoInput());
            nestedConnection.setIfModifiedSince(this.getIfModifiedSince());
            nestedConnection.setReadTimeout(this.getReadTimeout());
            nestedConnection.setUseCaches(this.getUseCaches());
            this.getRequestProperties().forEach((key, values) -> values.forEach(value -> nestedConnection.addRequestProperty((String)key, (String)value)));
            nestedConnection.setDoOutput(false);
            this.doConnect(nestedConnection);
            this.connected = true;
            this.nestedConnection = nestedConnection;
        }
        catch (IOException ex) {
            throw this.maybeWrapIoException(ex);
        }
    }

    @Override
    public final InputStream getInputStream() throws NestedUrlException {
        return this.nestedInputStream == null ? this.constructInputStream() : this.nestedInputStream;
    }

    private InputStream constructInputStream() throws NestedUrlException {
        Objects.requireNonNull(this.nestedConnection, () -> "internals are not connected to '" + String.valueOf(this.nestedUrl) + "', this is a bug!");
        try {
            InputStream nestedInputStream;
            this.nestedInputStream = nestedInputStream = this.nestInputStream(this.nestedConnection.getInputStream());
            return nestedInputStream;
        }
        catch (IOException ex) {
            NestedUrlException wrappedEx = this.maybeWrapIoException(ex);
            try {
                this.nestedConnection.getInputStream().close();
            }
            catch (Throwable closureEx) {
                wrappedEx.addSuppressed(closureEx);
            }
            throw wrappedEx;
        }
    }

    private NestedUrlException maybeWrapIoException(Throwable ex) {
        if (ex instanceof NestedUrlException) {
            NestedUrlException nestedEx = (NestedUrlException)ex;
            return nestedEx;
        }
        return new NestedUrlException("Failed to transfer '" + String.valueOf(this.nestedUrl) + "' wrapped with handler for protocol '" + this.url.getProtocol() + "', an inner exception was raised: " + String.valueOf(ex), ex);
    }

    void doConnect(URLConnection nestedConnection) throws IOException {
        nestedConnection.connect();
    }

    abstract InputStream nestInputStream(InputStream var1) throws IOException;

    static final class NestedUrlException
    extends IOException {
        NestedUrlException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

