/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import io.github.ascopes.protobufmavenplugin.generation.GenerationRequest;
import io.github.ascopes.protobufmavenplugin.plugins.BinaryPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugins.JvmPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;

@Description(value="Resolves and packages protoc plugins from various remote and local locations")
@MojoExecutionScoped
@Named
public final class ProjectPluginResolver {
    private final BinaryPluginResolver binaryPluginResolver;
    private final JvmPluginResolver jvmPluginResolver;

    @Inject
    ProjectPluginResolver(BinaryPluginResolver binaryPluginResolver, JvmPluginResolver jvmPluginResolver) {
        this.binaryPluginResolver = binaryPluginResolver;
        this.jvmPluginResolver = jvmPluginResolver;
    }

    public Collection<ResolvedProtocPlugin> resolveProjectPlugins(GenerationRequest request) throws ResolutionException {
        ArrayList<ResolvedProtocPlugin> plugins = new ArrayList<ResolvedProtocPlugin>();
        plugins.addAll(this.binaryPluginResolver.resolveMavenPlugins(request.getBinaryMavenPlugins(), request.getOutputDirectory()));
        plugins.addAll(this.binaryPluginResolver.resolvePathPlugins(request.getBinaryPathPlugins(), request.getOutputDirectory()));
        plugins.addAll(this.binaryPluginResolver.resolveUrlPlugins(request.getBinaryUrlPlugins(), request.getOutputDirectory()));
        plugins.addAll(this.jvmPluginResolver.resolveMavenPlugins(request.getJvmMavenPlugins(), request.getOutputDirectory()));
        plugins.trimToSize();
        return Collections.unmodifiableList(plugins);
    }
}

