/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import com.google.protobuf.DescriptorProtos;
import io.github.ascopes.protobufmavenplugin.digests.Digest;
import io.github.ascopes.protobufmavenplugin.fs.FileUtils;
import io.github.ascopes.protobufmavenplugin.fs.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.sources.DescriptorListing;
import io.github.ascopes.protobufmavenplugin.sources.ImmutableDescriptorListing;
import io.github.ascopes.protobufmavenplugin.sources.ImmutableSourceListing;
import io.github.ascopes.protobufmavenplugin.sources.SourceListing;
import io.github.ascopes.protobufmavenplugin.sources.filter.FileFilter;
import io.github.ascopes.protobufmavenplugin.utils.ConcurrentExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Discovers proto sources in various packaging formats on the file system")
@MojoExecutionScoped
@Named
final class ProtoSourceResolver {
    private static final Set<String> XML_FILE_EXTENSIONS = Set.of(".pom", ".xml");
    private static final Set<String> ZIP_FILE_EXTENSIONS = Set.of(".ear", ".jar", ".war", ".zip");
    private static final Logger log = LoggerFactory.getLogger(ProtoSourceResolver.class);
    private final ConcurrentExecutor concurrentExecutor;
    private final TemporarySpace temporarySpace;

    @Inject
    ProtoSourceResolver(ConcurrentExecutor concurrentExecutor, TemporarySpace temporarySpace) {
        this.concurrentExecutor = concurrentExecutor;
        this.temporarySpace = temporarySpace;
    }

    Collection<DescriptorListing> resolveDescriptors(Collection<Path> descriptorFilePaths, FileFilter filter) {
        return descriptorFilePaths.stream().map(FileUtils::normalize).distinct().map(path -> this.concurrentExecutor.submit(() -> this.resolveDescriptor((Path)path, filter))).collect(this.concurrentExecutor.awaiting()).stream().flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }

    private Optional<DescriptorListing> resolveDescriptor(Path descriptorFilePath, FileFilter filter) throws IOException {
        Optional<DescriptorListing> optional;
        block9: {
            if (!Files.exists(descriptorFilePath, new LinkOption[0])) {
                log.debug("Skipping descriptor lookup in path \"{}\" as it does not exist", (Object)descriptorFilePath);
                return Optional.empty();
            }
            InputStream inputStream = FileUtils.newBufferedInputStream(descriptorFilePath, new OpenOption[0]);
            try {
                optional = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)inputStream).getFileList().stream().map(DescriptorProtos.FileDescriptorProto::getName).peek(protoFile -> log.trace("Found virtual proto file \"{}\" in descriptor \"{}\"", protoFile, (Object)descriptorFilePath)).filter(filter::matches).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Optional::of)).filter(Predicate.not(Collection::isEmpty)).map(protoFiles -> ImmutableDescriptorListing.builder().descriptorFilePath(descriptorFilePath).sourceFiles((Iterable<String>)protoFiles).build());
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IOException("Failed to read/parse input descriptor " + String.valueOf(descriptorFilePath) + " due to " + ex.getClass().getSimpleName() + ": " + ex.getMessage(), ex);
                }
            }
            inputStream.close();
        }
        return optional;
    }

    Collection<SourceListing> resolveSources(Collection<Path> rootPaths, FileFilter filter) {
        return rootPaths.stream().map(FileUtils::normalize).distinct().map(path -> this.concurrentExecutor.submit(() -> this.resolveSources((Path)path, filter))).collect(this.concurrentExecutor.awaiting()).stream().flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }

    private Optional<SourceListing> resolveSources(Path rootPath, FileFilter filter) throws IOException {
        if (!Files.exists(rootPath, new LinkOption[0])) {
            log.debug("Skipping source lookup in path \"{}\" as it does not exist", (Object)rootPath);
            return Optional.empty();
        }
        return Files.isRegularFile(rootPath, new LinkOption[0]) ? this.resolveSourcesWithinFile(rootPath, filter) : this.resolveSourcesWithinDirectory(rootPath, filter);
    }

    private Optional<SourceListing> resolveSourcesWithinFile(Path rootPath, FileFilter filter) throws IOException {
        Optional<String> fileExtension = FileUtils.getFileExtension(rootPath);
        if (fileExtension.filter(ZIP_FILE_EXTENSIONS::contains).isPresent()) {
            return this.resolveSourcesWithinArchive(rootPath, filter);
        }
        if (fileExtension.filter(XML_FILE_EXTENSIONS::contains).isPresent()) {
            log.debug("Ignoring invalid dependency on XML artifact at \"{}\"", (Object)rootPath);
            return Optional.empty();
        }
        log.warn("Ignoring unknown artifact type at \"{}\"", (Object)rootPath);
        return Optional.empty();
    }

    private Optional<SourceListing> resolveSourcesWithinArchive(Path rootPath, FileFilter filter) throws IOException {
        try (FileSystem vfs = FileUtils.openZipAsFileSystem(rootPath);){
            Path vfsRoot = vfs.getRootDirectories().iterator().next();
            Optional<SourceListing> sourceFiles = this.resolveSources(vfsRoot, filter);
            if (sourceFiles.isEmpty()) {
                Optional<SourceListing> optional = Optional.empty();
                return optional;
            }
            Path extractionRoot = this.getArchiveExtractionRoot().resolve(this.generateUniqueName(rootPath));
            List<Path> relocatedSourceFiles = FileUtils.rebaseFileTree(vfsRoot, extractionRoot, sourceFiles.get().getSourceFiles().stream());
            Optional<SourceListing> optional = Optional.of(this.createSourceListing(relocatedSourceFiles, extractionRoot));
            return optional;
        }
    }

    private Optional<SourceListing> resolveSourcesWithinDirectory(Path rootPath, FileFilter filter) throws IOException {
        try (Stream<Path> stream = Files.walk(rootPath, new FileVisitOption[0]);){
            Optional<SourceListing> optional = stream.filter(filePath -> filter.matches(rootPath, (Path)filePath)).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Optional::of)).filter(Predicate.not(Collection::isEmpty)).map(protoFiles -> this.createSourceListing((Collection<Path>)protoFiles, rootPath));
            return optional;
        }
    }

    private SourceListing createSourceListing(Collection<Path> sourceFiles, Path rootPath) {
        return ImmutableSourceListing.builder().addAllSourceFiles(sourceFiles).sourceRoot(rootPath).build();
    }

    private Path getArchiveExtractionRoot() {
        return this.temporarySpace.createTemporarySpace("archives");
    }

    private String generateUniqueName(Path path) {
        String name = FileUtils.normalize(path).toUri().toASCIIString();
        String digest = Digest.compute("SHA-1", name).toHexString();
        return FileUtils.getFileNameWithoutExtension(path) + "-" + digest;
    }
}

