/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies.aether;

import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherArtifactMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.sisu.Description;
import org.jspecify.annotations.Nullable;

@Description(value="Provides dependencyManagement resolution for Aether dependencies")
@MojoExecutionScoped
@Named
final class AetherDependencyManagement {
    private final Map<String, Artifact> effectiveDependencyManagement;

    @Inject
    AetherDependencyManagement(MavenSession mavenSession, AetherArtifactMapper artifactMapper) {
        this.effectiveDependencyManagement = Optional.of(mavenSession.getCurrentProject()).map(MavenProject::getDependencyManagement).map(DependencyManagement::getDependencies).stream().flatMap(Collection::stream).map(artifactMapper::mapMavenDependencyToEclipseArtifact).collect(AetherDependencyManagement.deduplicateArtifacts());
    }

    Dependency fillManagedAttributes(Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        if (AetherDependencyManagement.isSpecified(artifact.getVersion())) {
            return dependency;
        }
        String key = AetherDependencyManagement.getDependencyManagementKey(artifact);
        Artifact managedArtifact = this.effectiveDependencyManagement.get(key);
        if (managedArtifact == null) {
            return dependency;
        }
        return new Dependency(managedArtifact, dependency.getScope(), dependency.getOptional(), dependency.getExclusions());
    }

    public static Collector<Artifact, ?, Map<String, Artifact>> deduplicateArtifacts() {
        return Collectors.collectingAndThen(Collectors.toMap(AetherDependencyManagement::getDependencyManagementKey, Function.identity(), AetherDependencyManagement::newestArtifact, LinkedHashMap::new), Collections::unmodifiableMap);
    }

    private static String getDependencyManagementKey(Artifact artifact) {
        StringBuilder builder = new StringBuilder().append(artifact.getGroupId()).append(":").append(artifact.getArtifactId()).append(":").append(artifact.getExtension());
        if (AetherDependencyManagement.isSpecified(artifact.getClassifier())) {
            builder.append(":").append(artifact.getClassifier());
        }
        return builder.toString();
    }

    private static Artifact newestArtifact(Artifact a, Artifact b) {
        ComparableVersion versionB;
        ComparableVersion versionA = AetherDependencyManagement.parseVersion(a.getVersion());
        return versionA.compareTo(versionB = AetherDependencyManagement.parseVersion(b.getVersion())) < 0 ? b : a;
    }

    private static boolean isSpecified(@Nullable String value) {
        return value != null && !value.isBlank();
    }

    private static ComparableVersion parseVersion(@Nullable String version) {
        if (!AetherDependencyManagement.isSpecified(version)) {
            version = "0.0.0-a0";
        }
        return new ComparableVersion(version);
    }
}

