/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.digests;

import io.github.ascopes.protobufmavenplugin.digests.DigestException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class Digest {
    private final String algorithm;
    private final byte[] digest;

    Digest(String algorithm, byte[] digest) {
        this.algorithm = algorithm;
        this.digest = digest;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Digest)) {
            return false;
        }
        Digest that = (Digest)other;
        return Objects.equals(this.algorithm, that.algorithm) && Arrays.equals(this.digest, that.digest);
    }

    public int hashCode() {
        return this.algorithm.hashCode() ^ Arrays.hashCode(this.digest);
    }

    public String toString() {
        return this.algorithm + ":" + Digest.encodeHex(this.digest);
    }

    public String toHexString() {
        return Digest.encodeHex(this.digest);
    }

    public void verify(InputStream inputStream) throws IOException {
        Digest actualDigest = Digest.compute(this.algorithm, inputStream);
        if (!actualDigest.equals(this)) {
            throw new DigestException("Actual digest '" + String.valueOf(actualDigest) + "' does not match expected digest '" + String.valueOf(this) + "'");
        }
    }

    public static Digest from(String algorithm, String hex) {
        MessageDigest messageDigest = Digest.getMessageDigest(algorithm);
        byte[] data = Digest.decodeHex(hex);
        if (data.length != messageDigest.getDigestLength()) {
            throw new DigestException("Illegal length " + data.length + " for decoded digest '" + hex + "' with algorithm '" + messageDigest.getAlgorithm() + "', expected " + messageDigest.getDigestLength());
        }
        return new Digest(messageDigest.getAlgorithm(), data);
    }

    public static Digest compute(String algorithm, String text) {
        return Digest.compute(algorithm, text.getBytes(StandardCharsets.UTF_8));
    }

    public static Digest compute(String algorithm, byte[] data) {
        try {
            return Digest.compute(algorithm, new ByteArrayInputStream(data));
        }
        catch (IOException ex) {
            throw new IllegalStateException("unreachable", ex);
        }
    }

    public static Digest compute(String algorithm, InputStream inputStream) throws IOException {
        int offset;
        MessageDigest messageDigest = Digest.getMessageDigest(algorithm);
        byte[] buff = new byte[4096];
        while ((offset = inputStream.read(buff)) != -1) {
            messageDigest.update(buff, 0, offset);
        }
        return new Digest(messageDigest.getAlgorithm(), messageDigest.digest());
    }

    private static MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new DigestException("Digest '" + algorithm + "' is not supported by this JVM", ex);
        }
    }

    private static byte[] decodeHex(String hex) {
        byte[] decoded = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); i += 2) {
            try {
                String hexByte = hex.substring(i, i + 2);
                decoded[i / 2] = (byte)Integer.parseUnsignedInt(hexByte, 16);
                continue;
            }
            catch (IndexOutOfBoundsException | NumberFormatException ex) {
                throw new DigestException("Invalid hex byte at position " + (i + 1) + " in hexadecimal string '" + hex + "'", ex);
            }
        }
        return decoded;
    }

    private static String encodeHex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            String hexDigit = Integer.toHexString(Byte.toUnsignedInt(b));
            if (hexDigit.length() == 1) {
                sb.append('0');
            }
            sb.append(hexDigit);
        }
        return sb.toString();
    }
}

