/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.dependencies.PlatformClassifierFactory;
import io.github.ascopes.protobufmavenplugin.fs.FileUtils;
import io.github.ascopes.protobufmavenplugin.fs.UriResourceFetcher;
import io.github.ascopes.protobufmavenplugin.plugins.ImmutableMavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.ImmutableResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.MavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.PathProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.ProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.UriProtocPlugin;
import io.github.ascopes.protobufmavenplugin.utils.Digest;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import io.github.ascopes.protobufmavenplugin.utils.SystemPathBinaryResolver;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Resolves native binary protoc plugins from various remote and local locations")
@MojoExecutionScoped
@Named
final class BinaryPluginResolver {
    private static final Logger log = LoggerFactory.getLogger(BinaryPluginResolver.class);
    private final MavenArtifactPathResolver artifactPathResolver;
    private final PlatformClassifierFactory platformClassifierFactory;
    private final SystemPathBinaryResolver systemPathResolver;
    private final UriResourceFetcher urlResourceFetcher;

    @Inject
    BinaryPluginResolver(MavenArtifactPathResolver artifactPathResolver, PlatformClassifierFactory platformClassifierFactory, SystemPathBinaryResolver systemPathResolver, UriResourceFetcher urlResourceFetcher) {
        this.artifactPathResolver = artifactPathResolver;
        this.platformClassifierFactory = platformClassifierFactory;
        this.systemPathResolver = systemPathResolver;
        this.urlResourceFetcher = urlResourceFetcher;
    }

    Collection<ResolvedProtocPlugin> resolveMavenPlugins(Collection<? extends MavenProtocPlugin> plugins, Path defaultOutputDirectory) throws ResolutionException {
        return this.resolveAll(plugins, defaultOutputDirectory, this::resolveMavenPlugin);
    }

    Collection<ResolvedProtocPlugin> resolvePathPlugins(Collection<? extends PathProtocPlugin> plugins, Path defaultOutputDirectory) throws ResolutionException {
        return this.resolveAll(plugins, defaultOutputDirectory, this::resolvePathPlugin);
    }

    Collection<ResolvedProtocPlugin> resolveUrlPlugins(Collection<? extends UriProtocPlugin> plugins, Path defaultOutputDirectory) throws ResolutionException {
        return this.resolveAll(plugins, defaultOutputDirectory, this::resolveUrlPlugin);
    }

    private Optional<ResolvedProtocPlugin> resolveMavenPlugin(MavenProtocPlugin plugin, Path defaultOutputDirectory) throws ResolutionException {
        ImmutableMavenProtocPlugin.Builder pluginBuilder = ImmutableMavenProtocPlugin.builder().from(plugin);
        if (plugin.getClassifier() == null) {
            String classifier = this.platformClassifierFactory.getClassifier(plugin.getArtifactId());
            pluginBuilder.classifier(classifier);
        }
        if (plugin.getType() == null) {
            pluginBuilder.type("exe");
        }
        plugin = pluginBuilder.build();
        log.debug("Resolving Maven protoc plugin {}", (Object)plugin);
        Path path = this.artifactPathResolver.resolveArtifact(plugin);
        this.makeExecutable(path);
        return Optional.of(this.createResolvedProtocPlugin(plugin, defaultOutputDirectory, path));
    }

    private Optional<ResolvedProtocPlugin> resolvePathPlugin(PathProtocPlugin plugin, Path defaultOutputDirectory) throws ResolutionException {
        log.debug("Resolving Path protoc plugin {}", (Object)plugin);
        Optional<Path> maybePath = this.systemPathResolver.resolve(plugin.getName());
        if (maybePath.isEmpty() && plugin.isOptional()) {
            return Optional.empty();
        }
        Path path = maybePath.orElseThrow(() -> new ResolutionException("No plugin named " + plugin.getName() + " was found on the system path"));
        return Optional.of(this.createResolvedProtocPlugin(plugin, defaultOutputDirectory, path));
    }

    private Optional<ResolvedProtocPlugin> resolveUrlPlugin(UriProtocPlugin plugin, Path defaultOutputDirectory) throws ResolutionException {
        log.debug("Resolving URL protoc plugin {}", (Object)plugin);
        Optional<Path> maybePath = this.urlResourceFetcher.fetchFileFromUri(plugin.getUrl(), ".exe");
        if (maybePath.isEmpty() && plugin.isOptional()) {
            return Optional.empty();
        }
        Path path = maybePath.orElseThrow(() -> new ResolutionException("Plugin at " + String.valueOf(plugin.getUrl()) + " does not exist"));
        if (plugin.getDigest() != null) {
            log.debug("Verifying digest of {} against {}", (Object)plugin.getUrl(), (Object)plugin.getDigest());
            try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                plugin.getDigest().verify(is);
            }
            catch (IOException ex) {
                throw new ResolutionException("Failed to compute digest of " + String.valueOf(plugin.getUrl()) + ": " + String.valueOf(ex), ex);
            }
        }
        this.makeExecutable(path);
        return Optional.of(this.createResolvedProtocPlugin(plugin, defaultOutputDirectory, path));
    }

    private ResolvedProtocPlugin createResolvedProtocPlugin(ProtocPlugin plugin, Path defaultOutputDirectory, Path path) {
        return ImmutableResolvedProtocPlugin.builder().id(Digest.compute("SHA-1", path.toString()).toHexString()).options(plugin.getOptions()).order(plugin.getOrder()).outputDirectory(Objects.requireNonNullElse(plugin.getOutputDirectory(), defaultOutputDirectory)).path(path).build();
    }

    private <P extends ProtocPlugin> Collection<ResolvedProtocPlugin> resolveAll(Collection<? extends P> plugins, Path defaultOutputDirectory, Resolver<? super P> resolver) throws ResolutionException {
        ArrayList<ResolvedProtocPlugin> resolvedPlugins = new ArrayList<ResolvedProtocPlugin>();
        for (ProtocPlugin plugin : plugins) {
            if (plugin.isSkip()) {
                log.info("Skipping plugin {}", (Object)plugin);
                continue;
            }
            resolver.resolve(plugin, defaultOutputDirectory).ifPresentOrElse(resolvedPlugins::add, this.skipUnresolvedPlugin(plugin));
        }
        return resolvedPlugins;
    }

    private Runnable skipUnresolvedPlugin(ProtocPlugin plugin) {
        return () -> log.info("Skipping unresolved missing plugin {}", (Object)plugin);
    }

    private void makeExecutable(Path path) throws ResolutionException {
        try {
            FileUtils.makeExecutable(path);
        }
        catch (IOException ex) {
            throw new ResolutionException("Failed to set executable bit on protoc plugin", ex);
        }
    }

    @FunctionalInterface
    private static interface Resolver<P extends ProtocPlugin> {
        public Optional<ResolvedProtocPlugin> resolve(P var1, Path var2) throws ResolutionException;
    }
}

