/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class HttpRequestException
extends IOException {
    private final int statusCode;
    private final @Nullable String correlationId;
    private final @Nullable String requestId;
    private final @Nullable String wwwAuthenticate;
    private final @Nullable String proxyAuthenticate;
    private final @Nullable String responseBody;

    public HttpRequestException(String message, int statusCode, @Nullable String correlationId, @Nullable String requestId, @Nullable String wwwAuthenticate, @Nullable String proxyAuthenticate, @Nullable String responseBody) {
        super(message);
        this.statusCode = statusCode;
        this.correlationId = correlationId;
        this.requestId = requestId;
        this.wwwAuthenticate = wwwAuthenticate;
        this.proxyAuthenticate = proxyAuthenticate;
        this.responseBody = responseBody;
    }

    public static HttpRequestException fromHttpResponse(HttpResponse<InputStream> response) {
        String body = HttpRequestException.asText(response.body(), 500);
        String correlationId = HttpRequestException.extractHeader(response, "Correlation-Id", "X-Correlation-Id");
        String requestId = HttpRequestException.extractHeader(response, "Request-Id", "X-Request-Id");
        return new HttpRequestException("HTTP " + response.statusCode() + " from " + String.valueOf(response.uri()), response.statusCode(), correlationId, requestId, HttpRequestException.extractHeader(response, "WWW-Authenticate"), HttpRequestException.extractHeader(response, "Proxy-Authenticate"), body);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String asText(InputStream stream, int maxLength) {
        if (stream == null) {
            return null;
        }
        try (InputStream inputStream = stream;){
            byte[] body = stream.readNBytes(maxLength + 1);
            String text = new String(body, StandardCharsets.UTF_8);
            if (text.length() > maxLength) {
                String string2 = text.substring(0, maxLength) + "... [truncated]";
                return string2;
            }
            String string = text;
            return string;
        }
        catch (Exception e) {
            return "<binary or unreadable response body>";
        }
    }

    private static @Nullable String extractHeader(HttpResponse<InputStream> response, String ... names) {
        for (String name : names) {
            Optional<String> val = response.headers().firstValue(name);
            if (!val.isPresent()) continue;
            return val.get();
        }
        return null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public @Nullable String getCorrelationId() {
        return this.correlationId;
    }

    public @Nullable String getRequestId() {
        return this.requestId;
    }

    public @Nullable String getWwwAuthenticate() {
        return this.wwwAuthenticate;
    }

    public @Nullable String getProxyAuthenticate() {
        return this.proxyAuthenticate;
    }

    public @Nullable String getResponseBody() {
        return this.responseBody;
    }

    @Override
    public String toString() {
        return "HttpClientUrlConnectionException{statusCode=" + this.statusCode + ", correlationId='" + this.correlationId + "', requestId='" + this.requestId + "', wwwAuthenticate='" + this.wwwAuthenticate + "', proxyAuthenticate='" + this.proxyAuthenticate + "', responseBody='" + this.responseBody + "'}";
    }
}

