/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import io.github.ascopes.protobufmavenplugin.sources.SourceListing;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@Generated(from="SourceListing", generator="Immutables")
public final class ImmutableSourceListing
implements SourceListing {
    private final Path sourceRoot;
    private final Set<Path> sourceProtoFiles;

    private ImmutableSourceListing(Builder builder) {
        this.sourceRoot = builder.sourceRoot;
        this.sourceProtoFiles = builder.sourceProtoFiles == null ? Collections.emptySet() : ImmutableSourceListing.createUnmodifiableSet(builder.sourceProtoFiles);
    }

    @Override
    public Path getSourceRoot() {
        return this.sourceRoot;
    }

    @Override
    public Set<Path> getSourceProtoFiles() {
        return this.sourceProtoFiles;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSourceListing && this.equalTo(0, (ImmutableSourceListing)another);
    }

    private boolean equalTo(int synthetic, ImmutableSourceListing another) {
        return Objects.equals(this.sourceRoot, another.sourceRoot) && this.sourceProtoFiles.equals(another.sourceProtoFiles);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sourceRoot);
        h += (h << 5) + this.sourceProtoFiles.hashCode();
        return h;
    }

    public String toString() {
        return "SourceListing{sourceRoot=" + String.valueOf(this.sourceRoot) + ", sourceProtoFiles=" + String.valueOf(this.sourceProtoFiles) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="SourceListing", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_ROOT = 1L;
        private long initBits = 1L;
        private Path sourceRoot;
        private List<Path> sourceProtoFiles = null;

        private Builder() {
        }

        public final Builder from(SourceListing instance) {
            Objects.requireNonNull(instance, "instance");
            Path sourceRootValue = instance.getSourceRoot();
            if (sourceRootValue != null) {
                this.sourceRoot(sourceRootValue);
            }
            this.addAllSourceProtoFiles(instance.getSourceProtoFiles());
            return this;
        }

        public final Builder sourceRoot(Path sourceRoot) {
            this.sourceRoot = sourceRoot;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSourceProtoFiles(Path element) {
            if (this.sourceProtoFiles == null) {
                this.sourceProtoFiles = new ArrayList<Path>();
            }
            this.sourceProtoFiles.add(element);
            return this;
        }

        public final Builder addSourceProtoFiles(Path ... elements) {
            if (this.sourceProtoFiles == null) {
                this.sourceProtoFiles = new ArrayList<Path>();
            }
            for (Path element : elements) {
                this.sourceProtoFiles.add(element);
            }
            return this;
        }

        public final Builder sourceProtoFiles(Iterable<? extends Path> elements) {
            this.sourceProtoFiles = new ArrayList<Path>();
            return this.addAllSourceProtoFiles(elements);
        }

        public final Builder addAllSourceProtoFiles(Iterable<? extends Path> elements) {
            Objects.requireNonNull(elements, "sourceProtoFiles element");
            if (this.sourceProtoFiles == null) {
                this.sourceProtoFiles = new ArrayList<Path>();
            }
            for (Path path : elements) {
                this.sourceProtoFiles.add(path);
            }
            return this;
        }

        public ImmutableSourceListing build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSourceListing(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceRoot");
            }
            return "Cannot build SourceListing, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

