/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.generation;

import io.github.ascopes.protobufmavenplugin.generation.GenerationRequest;
import io.github.ascopes.protobufmavenplugin.generation.SourceRootRegistrar;
import io.github.ascopes.protobufmavenplugin.plugins.ProjectPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.protoc.CommandLineExecutor;
import io.github.ascopes.protobufmavenplugin.protoc.ProtocArgumentFileBuilderBuilder;
import io.github.ascopes.protobufmavenplugin.protoc.ProtocResolver;
import io.github.ascopes.protobufmavenplugin.sources.ProjectInputListing;
import io.github.ascopes.protobufmavenplugin.sources.ProjectInputResolver;
import io.github.ascopes.protobufmavenplugin.sources.SourceListing;
import io.github.ascopes.protobufmavenplugin.sources.incremental.IncrementalCacheManager;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class ProtobufBuildOrchestrator {
    private static final Logger log = LoggerFactory.getLogger(ProtobufBuildOrchestrator.class);
    private final MavenSession mavenSession;
    private final ProtocResolver protocResolver;
    private final ProjectInputResolver projectInputResolver;
    private final ProjectPluginResolver projectPluginResolver;
    private final IncrementalCacheManager incrementalCacheManager;
    private final CommandLineExecutor commandLineExecutor;

    @Inject
    public ProtobufBuildOrchestrator(MavenSession mavenSession, ProtocResolver protocResolver, ProjectInputResolver projectInputResolver, ProjectPluginResolver projectPluginResolver, IncrementalCacheManager incrementalCacheManager, CommandLineExecutor commandLineExecutor) {
        this.mavenSession = mavenSession;
        this.protocResolver = protocResolver;
        this.projectInputResolver = projectInputResolver;
        this.projectPluginResolver = projectPluginResolver;
        this.incrementalCacheManager = incrementalCacheManager;
        this.commandLineExecutor = commandLineExecutor;
    }

    public boolean generate(GenerationRequest request) throws ResolutionException, IOException {
        log.debug("The provided protobuf GenerationRequest is: {}", (Object)request);
        Path protocPath = this.discoverProtocPath(request);
        Collection<ResolvedProtocPlugin> resolvedPlugins = this.projectPluginResolver.resolveProjectPlugins(request);
        ProjectInputListing projectInputs = this.projectInputResolver.resolveProjectInputs(request);
        if (projectInputs.getCompilableSources().isEmpty()) {
            if (request.isFailOnMissingSources()) {
                log.error("No protobuf sources found. If this is unexpected, check your configuration and try again.");
                return false;
            }
            log.warn("No protobuf sources found.");
            return true;
        }
        if (resolvedPlugins.isEmpty() && request.getEnabledLanguages().isEmpty() && request.getOutputDescriptorFile() == null) {
            if (request.isFailOnMissingTargets()) {
                log.error("No languages are enabled and no plugins found, check your configuration and try again.");
                return false;
            }
            log.warn("No languages are enabled and no plugins were found. There is nothing to do!");
            return true;
        }
        this.createOutputDirectories(request);
        this.registerSourceRoots(request);
        Collection<Path> compilableSources = this.computeActualSourcesToCompile(request, projectInputs);
        if (compilableSources.isEmpty()) {
            this.incrementalCacheManager.updateIncrementalCache();
            return true;
        }
        ProtocArgumentFileBuilderBuilder args = new ProtocArgumentFileBuilderBuilder().addLanguages(request.getEnabledLanguages(), request.getOutputDirectory(), request.isLiteEnabled()).addImportPaths(projectInputs.getCompilableSources().stream().map(SourceListing::getSourceRoot).collect(Collectors.toUnmodifiableList())).addImportPaths(projectInputs.getDependencySources().stream().map(SourceListing::getSourceRoot).collect(Collectors.toUnmodifiableList())).addPlugins(resolvedPlugins, request.getOutputDirectory()).addSourcePaths(compilableSources).setFatalWarnings(request.isFatalWarnings());
        if (request.getOutputDescriptorFile() != null) {
            args.setOutputDescriptorFile(request.getOutputDescriptorFile(), request.isOutputDescriptorIncludeImports(), request.isOutputDescriptorIncludeSourceInfo(), request.isOutputDescriptorRetainOptions());
        }
        if (!this.commandLineExecutor.execute(protocPath, args.build())) {
            return false;
        }
        this.incrementalCacheManager.updateIncrementalCache();
        if (request.isEmbedSourcesInClassOutputs()) {
            this.embedSourcesInClassOutputs(request.getSourceRootRegistrar(), projectInputs.getCompilableSources());
        }
        return true;
    }

    private Path discoverProtocPath(GenerationRequest request) throws ResolutionException {
        return this.protocResolver.resolve(request.getProtocVersion()).orElseThrow(() -> new ResolutionException("Protoc binary was not found"));
    }

    private void createOutputDirectories(GenerationRequest request) throws IOException {
        Path directory = request.getOutputDirectory();
        log.debug("Creating {}", (Object)directory);
        FileUtils.getFileExtension(directory).filter(".jar"::equalsIgnoreCase).ifPresent(ext -> {
            throw new IllegalArgumentException("The output directory '" + String.valueOf(directory) + "' cannot be a path with a JAR file extension, due to limitations with how protoc operates on file names.");
        });
        Files.createDirectories(directory, new FileAttribute[0]);
    }

    private void registerSourceRoots(GenerationRequest request) {
        if (request.isRegisterAsCompilationRoot()) {
            request.getSourceRootRegistrar().registerSourceRoot(this.mavenSession, request.getOutputDirectory());
        }
    }

    private Collection<Path> computeActualSourcesToCompile(GenerationRequest request, ProjectInputListing projectInputs) throws IOException {
        Collection<Path> sourcesToCompile;
        int totalSourceFileCount = projectInputs.getCompilableSources().stream().mapToInt(sourcePath -> sourcePath.getSourceProtoFiles().size()).sum();
        Collection<Path> collection = sourcesToCompile = this.shouldIncrementallyCompile(request) ? this.incrementalCacheManager.determineSourcesToCompile(projectInputs) : SourceListing.flattenSourceProtoFiles(projectInputs.getCompilableSources());
        if (sourcesToCompile.isEmpty()) {
            log.info("Found {} source files, all are up-to-date, none will be regenerated this time", (Object)totalSourceFileCount);
            return List.of();
        }
        log.info("Generating source code from {} (discovered {} within {})", new Object[]{ProtobufBuildOrchestrator.pluralize(sourcesToCompile.size(), "source file"), ProtobufBuildOrchestrator.pluralize(totalSourceFileCount, "source file"), ProtobufBuildOrchestrator.pluralize(projectInputs.getCompilableSources().size(), "source path")});
        return sourcesToCompile;
    }

    private boolean shouldIncrementallyCompile(GenerationRequest request) {
        if (!request.isIncrementalCompilationEnabled()) {
            log.debug("Incremental compilation is disabled");
            return false;
        }
        if (request.getOutputDescriptorFile() != null) {
            log.info("Incremental compilation is disabled since proto descriptor generation has been requested.");
            return false;
        }
        log.debug("Will use incremental compilation");
        return true;
    }

    private void embedSourcesInClassOutputs(SourceRootRegistrar registrar, Collection<SourceListing> listings) throws ResolutionException {
        for (SourceListing listing : listings) {
            try {
                registrar.embedListing(this.mavenSession, listing);
            }
            catch (IOException ex) {
                throw new ResolutionException("Failed to embed " + String.valueOf(listing.getSourceRoot()) + " into the class outputs directory", ex);
            }
        }
    }

    private static String pluralize(int count, String name) {
        return count == 1 ? "1 " + name : count + " " + name + "s";
    }
}

